/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

public class VisitTracker<K> {
    private int validateCount;
    private int activateCount;
    private int passivateCount;
    private boolean destroyed;
    private int id;
    private K key;

    public VisitTracker() {
        this.reset();
    }

    public VisitTracker(int id) {
        this.id = id;
        this.reset();
    }

    public VisitTracker(int id, K key) {
        this.id = id;
        this.key = key;
        this.reset();
    }

    public void activate() {
        if (this.destroyed) {
            this.fail("attempted to activate a destroyed object");
        }
        ++this.activateCount;
    }

    public void destroy() {
        this.destroyed = true;
    }

    private void fail(String message) {
        throw new IllegalStateException(message);
    }

    public int getActivateCount() {
        return this.activateCount;
    }

    public int getId() {
        return this.id;
    }

    public K getKey() {
        return this.key;
    }

    public int getPassivateCount() {
        return this.passivateCount;
    }

    public int getValidateCount() {
        return this.validateCount;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void passivate() {
        if (this.destroyed) {
            this.fail("attempted to passivate a destroyed object");
        }
        ++this.passivateCount;
    }

    public void reset() {
        this.validateCount = 0;
        this.activateCount = 0;
        this.passivateCount = 0;
        this.destroyed = false;
    }

    public String toString() {
        return "Key: " + this.key + " id: " + this.id;
    }

    public boolean validate() {
        if (this.destroyed) {
            this.fail("attempted to validate a destroyed object");
        }
        ++this.validateCount;
        return true;
    }
}

