/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface QueueControl {
    public static final String MESSAGE_COUNT_DESCRIPTION = "number of messages currently in this queue (includes scheduled, paged, and in-delivery messages)";
    public static final String DURABLE_MESSAGE_COUNT_DESCRIPTION = "number of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)";
    public static final String PERSISTENT_SIZE_DESCRIPTION = "persistent size of all messages (including durable and non-durable) currently in this queue (includes scheduled, paged, and in-delivery messages)";
    public static final String DURABLE_PERSISTENT_SIZE_DESCRIPTION = "persistent size of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)";
    public static final String SCHEDULED_MESSAGE_COUNT_DESCRIPTION = "number of scheduled messages in this queue";
    public static final String DURABLE_SCHEDULED_MESSAGE_COUNT_DESCRIPTION = "number of durable scheduled messages in this queue";
    public static final String SCHEDULED_SIZE_DESCRIPTION = "persistent size of scheduled messages in this queue";
    public static final String DURABLE_SCHEDULED_SIZE_DESCRIPTION = "persistent size of durable scheduled messages in this queue";
    public static final String DELIVERING_MESSAGE_COUNT_DESCRIPTION = "number of messages that this queue is currently delivering to its consumers";
    public static final String DURABLE_DELIVERING_MESSAGE_COUNT_DESCRIPTION = "number of durable messages that this queue is currently delivering to its consumers";
    public static final String DELIVERING_SIZE_DESCRIPTION = "persistent size of messages that this queue is currently delivering to its consumers";
    public static final String DURABLE_DELIVERING_SIZE_DESCRIPTION = "persistent size of durable messages that this queue is currently delivering to its consumers";
    public static final String CONSUMER_COUNT_DESCRIPTION = "number of consumers consuming messages from this queue";
    public static final String MESSAGES_ADDED_DESCRIPTION = "number of messages added to this queue since it was created";
    public static final String MESSAGES_ACKNOWLEDGED_DESCRIPTION = "number of messages acknowledged from this queue since it was created";
    public static final String MESSAGES_EXPIRED_DESCRIPTION = "number of messages expired from this queue since it was created";
    public static final String MESSAGES_KILLED_DESCRIPTION = "number of messages removed from this queue since it was created due to exceeding the max delivery attempts";

    @Attribute(desc="name of this queue")
    public String getName();

    @Attribute(desc="address this queue is bound to")
    public String getAddress();

    @Attribute(desc="ID of this queue")
    public long getID();

    @Attribute(desc="whether this queue is temporary")
    public boolean isTemporary();

    @Attribute(desc="whether this queue is used for a retroactive address")
    public boolean isRetroactiveResource();

    @Attribute(desc="whether this queue is durable")
    public boolean isDurable();

    @Attribute(desc="the user that created the queue")
    public String getUser();

    @Attribute(desc="routing type of this queue")
    public String getRoutingType();

    @Attribute(desc="filter associated with this queue")
    public String getFilter();

    @Attribute(desc="number of messages currently in this queue (includes scheduled, paged, and in-delivery messages)")
    public long getMessageCount();

    @Attribute(desc="persistent size of all messages (including durable and non-durable) currently in this queue (includes scheduled, paged, and in-delivery messages)")
    public long getPersistentSize();

    @Attribute(desc="number of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)")
    public long getDurableMessageCount();

    @Attribute(desc="persistent size of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)")
    public long getDurablePersistentSize();

    @Attribute(desc="whether this queue was created for the broker's internal use")
    public boolean isInternalQueue();

    @Attribute(desc="number of scheduled messages in this queue")
    public long getScheduledCount();

    @Attribute(desc="persistent size of scheduled messages in this queue")
    public long getScheduledSize();

    @Attribute(desc="number of durable scheduled messages in this queue")
    public long getDurableScheduledCount();

    @Attribute(desc="persistent size of durable scheduled messages in this queue")
    public long getDurableScheduledSize();

    @Attribute(desc="number of consumers consuming messages from this queue")
    public int getConsumerCount();

    @Attribute(desc="number of messages that this queue is currently delivering to its consumers")
    public int getDeliveringCount();

    @Attribute(desc="persistent size of messages that this queue is currently delivering to its consumers")
    public long getDeliveringSize();

    @Attribute(desc="number of durable messages that this queue is currently delivering to its consumers")
    public int getDurableDeliveringCount();

    @Attribute(desc="persistent size of durable messages that this queue is currently delivering to its consumers")
    public long getDurableDeliveringSize();

    @Attribute(desc="number of messages added to this queue since it was created")
    public long getMessagesAdded();

    @Attribute(desc="number of messages acknowledged from this queue since it was created")
    public long getMessagesAcknowledged();

    @Attribute(desc="number of messages acknowledged attempts from this queue since it was created")
    public long getAcknowledgeAttempts();

    @Attribute(desc="number of messages expired from this queue since it was created")
    public long getMessagesExpired();

    @Attribute(desc="number of messages removed from this queue since it was created due to exceeding the max delivery attempts")
    public long getMessagesKilled();

    @Attribute(desc="first message on the queue as JSON")
    public String getFirstMessageAsJSON() throws Exception;

    @Attribute(desc="timestamp of the first message in milliseconds")
    public Long getFirstMessageTimestamp() throws Exception;

    @Attribute(desc="age of the first message in milliseconds")
    public Long getFirstMessageAge() throws Exception;

    @Attribute(desc="expiry address associated with this queue")
    public String getExpiryAddress();

    @Attribute(desc="dead-letter address associated with this queue")
    public String getDeadLetterAddress();

    @Attribute(desc="maximum number of consumers allowed on this queue at any one time")
    public int getMaxConsumers();

    @Attribute(desc="purge this queue when the last consumer disconnects")
    public boolean isPurgeOnNoConsumers();

    @Attribute(desc="if the queue is enabled, default it is enabled, when disabled messages will not be routed to the queue")
    public boolean isEnabled();

    @Operation(desc="Enables routing of messages to the Queue", impact=1)
    public void enable() throws Exception;

    @Operation(desc="Disables routing of messages to the Queue", impact=1)
    public void disable() throws Exception;

    @Attribute(desc="is this queue managed by configuration (broker.xml)")
    public boolean isConfigurationManaged();

    @Attribute(desc="If the queue should route exclusively to one consumer")
    public boolean isExclusive();

    @Attribute(desc="is this queue a last value queue")
    public boolean isLastValue();

    @Attribute(desc="last value key")
    public String getLastValueKey();

    @Attribute(desc="Return the Consumers Before Dispatch")
    public int getConsumersBeforeDispatch();

    @Attribute(desc="Return the Delay Before Dispatch")
    public long getDelayBeforeDispatch();

    @Operation(desc="List the messages scheduled for delivery", impact=0)
    public Map<String, Object>[] listScheduledMessages() throws Exception;

    @Operation(desc="List the messages scheduled for delivery and returns them using JSON", impact=0)
    public String listScheduledMessagesAsJSON() throws Exception;

    @Operation(desc="List all messages being delivered per consumer")
    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws Exception;

    @Operation(desc="list all messages being delivered per consumer using JSON form")
    public String listDeliveringMessagesAsJSON() throws Exception;

    @Operation(desc="List all the messages in the queue matching the given filter", impact=0)
    public Map<String, Object>[] listMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="List all the messages in the queue matching the given filter and returns them using JSON", impact=0)
    public String listMessagesAsJSON(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter", impact=0)
    public long countMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue", impact=0)
    public long countMessages() throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter, grouped by the given property field", impact=0)
    public String countMessages(@Parameter(name="filter", desc="This filter separate account messages") String var1, @Parameter(name="groupByProperty", desc="This property to group by") String var2) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter")
    public long countDeliveringMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter, grouped by the given property field")
    public String countDeliveringMessages(@Parameter(name="filter", desc="This filter separate account messages") String var1, @Parameter(name="groupByProperty", desc="This property to group by") String var2) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean removeMessage(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="flushLimit", desc="Limit to flush transactions during the operation to avoid OutOfMemory") int var1, @Parameter(name="filter", desc="A message filter (can be empty)") String var2) throws Exception;

    @Operation(desc="Remove all the messages from the Queue (and returns the number of removed messages)", impact=1)
    public int removeAllMessages() throws Exception;

    @Operation(desc="Expire the messages corresponding to the given filter (and returns the number of expired messages)", impact=1)
    public int expireMessages(@Parameter(name="filter", desc="A message filter") String var1) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean expireMessage(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Retry the message corresponding to the given messageID to the original queue", impact=1)
    public boolean retryMessage(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Retry all messages on a DLQ to their respective original queues", impact=1)
    public int retryMessages() throws Exception;

    @Operation(desc="Retry all messages matching the given filter on a DLQ to their respective original queues", impact=1)
    public int retryMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue. rejectDuplicate=false on this case", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var3) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var3, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var4) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages). RejectDuplicates=false on this case.", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var3) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="flushLimit", desc="Limit to flush transactions during the operation to avoid OutOfMemory") int var1, @Parameter(name="filter", desc="A message filter (can be empty)") String var2, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var3, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var4) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="flushLimit", desc="Limit to flush transactions during the operation to avoid OutOfMemory") int var1, @Parameter(name="filter", desc="A message filter (can be empty)") String var2, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var3, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var4, @Parameter(name="messageCount", desc="Number of messages to move.") int var5) throws Exception;

    @Operation(desc="Send a copy of the message with given messageID to another queue)", impact=1)
    public boolean copyMessage(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="targetQueue", desc="The name of the queue to copy the messages to") String var3) throws Exception;

    @Operation(desc="Send the message corresponding to the given messageID to this queue's Dead Letter Address", impact=1)
    public boolean sendMessageToDeadLetterAddress(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Send the messages corresponding to the given filter to this queue's Dead Letter Address", impact=1)
    public int sendMessagesToDeadLetterAddress(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendMessage(@Parameter(name="headers", desc="The headers to add to the message") Map<String, String> var1, @Parameter(name="type", desc="A type for the message") int var2, @Parameter(name="body", desc="The body (byte[]) of the message encoded as a string using Base64") String var3, @Parameter(name="durable", desc="Whether the message is durable") boolean var4, @Parameter(name="user", desc="The user to authenticate with") String var5, @Parameter(name="password", desc="The users password to authenticate with") String var6) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected destination.", impact=1)
    public String sendMessage(@Parameter(name="headers", desc="The headers to add to the message") Map<String, String> var1, @Parameter(name="type", desc="A type for the message") int var2, @Parameter(name="body", desc="The body (byte[]) of the message encoded as a string using Base64") String var3, @Parameter(name="durable", desc="Whether the message is durable") boolean var4, @Parameter(name="user", desc="The user to authenticate with") String var5, @Parameter(name="password", desc="The users password to authenticate with") String var6, @Parameter(name="createMessageId", desc="whether or not to auto generate a Message ID") boolean var7) throws Exception;

    @Operation(desc="Change the priority of the message corresponding to the given messageID", impact=1)
    public boolean changeMessagePriority(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var3) throws Exception;

    @Operation(desc="Change the priority of the messages corresponding to the given filter", impact=1)
    public int changeMessagesPriority(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var2) throws Exception;

    @Operation(desc="List the message counters", impact=0)
    public String listMessageCounter() throws Exception;

    @Operation(desc="Reset the message counters", impact=0)
    public void resetMessageCounter() throws Exception;

    @Operation(desc="List the message counters as HTML", impact=0)
    public String listMessageCounterAsHTML() throws Exception;

    @Operation(desc="List the message counters history", impact=0)
    public String listMessageCounterHistory() throws Exception;

    @Deprecated
    @Operation(desc="List the message counters history HTML", impact=0)
    public String listMessageCounterHistoryAsHTML() throws Exception;

    @Operation(desc="Pauses the Queue", impact=1)
    public void pause() throws Exception;

    @Operation(desc="Pauses the Queue", impact=1)
    public void pause(@Parameter(name="persist", desc="if true, the pause state will be persisted.") boolean var1) throws Exception;

    @Operation(desc="Resumes delivery of queued messages and gets the queue out of paused state. It will also affected the state of a persisted pause.", impact=1)
    public void resume() throws Exception;

    @Operation(desc="List all the existent consumers on the Queue")
    public String listConsumersAsJSON() throws Exception;

    @Attribute(desc="whether the queue is paused")
    public boolean isPaused();

    @Attribute(desc="whether the queue's paused status is persisted")
    public boolean isPersistedPause();

    @Operation(desc="Browse Messages", impact=1)
    public CompositeData[] browse() throws Exception;

    @Operation(desc="Browse Messages", impact=1)
    public CompositeData[] browse(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Browse Messages", impact=1)
    public CompositeData[] browse(@Parameter(name="page", desc="Current page") int var1, @Parameter(name="pageSize", desc="Page size") int var2) throws Exception;

    @Operation(desc="Browse Messages", impact=1)
    public CompositeData[] browse(@Parameter(name="page", desc="Current page") int var1, @Parameter(name="pageSize", desc="Page size") int var2, @Parameter(name="filter", desc="filter") String var3) throws Exception;

    @Operation(desc="Resets the MessagesAdded property", impact=1)
    public void resetMessagesAdded() throws Exception;

    @Operation(desc="Resets the MessagesAcknowledged property", impact=1)
    public void resetMessagesAcknowledged() throws Exception;

    @Operation(desc="Resets the MessagesExpired property", impact=1)
    public void resetMessagesExpired() throws Exception;

    @Operation(desc="Resets the MessagesKilled property", impact=1)
    public void resetMessagesKilled() throws Exception;

    @Operation(desc="Flush internal executors", impact=1)
    public void flushExecutor();

    @Operation(desc="Resets all groups", impact=1)
    public void resetAllGroups();

    @Operation(desc="Reset the specified group", impact=1)
    public void resetGroup(@Parameter(name="groupID", desc="ID of group to reset") String var1);

    @Attribute(desc="Get the current number of active groups")
    public int getGroupCount();

    @Operation(desc="List all the existent group to consumers mappings on the Queue")
    public String listGroupsAsJSON() throws Exception;

    @Attribute(desc="Get the ring size")
    public long getRingSize();

    @Attribute(desc="whether the groups of this queue are automatically rebalanced")
    public boolean isGroupRebalance();

    @Attribute(desc="whether the dispatch is paused when groups of this queue are automatically rebalanced")
    public boolean isGroupRebalancePauseDispatch();

    @Attribute(desc="Get the group buckets")
    public int getGroupBuckets();

    @Attribute(desc="Get the header key to notify a consumer of a group change")
    public String getGroupFirstKey();

    @Attribute(desc="return how many messages are stuck in prepared transactions")
    public int getPreparedTransactionMessageCount();

    @Operation(desc="Immediately deliver the scheduled messages which match the filter", impact=1)
    public void deliverScheduledMessages(@Parameter(name="filter", desc="filter to match messages to deliver") String var1) throws Exception;

    @Operation(desc="Immediately deliver the scheduled message with the specified message ID", impact=1)
    public void deliverScheduledMessage(@Parameter(name="messageID", desc="ID of the message to deliver") long var1) throws Exception;

    @Attribute(desc="whether this queue is available for auto deletion")
    public boolean isAutoDelete();

    @Operation(desc="Returns first message on the queue as JSON", impact=0)
    public String peekFirstMessageAsJSON() throws Exception;

    @Operation(desc="Returns first scheduled message on the queue as JSON", impact=0)
    public String peekFirstScheduledMessageAsJSON() throws Exception;
}

