/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.tools;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.agents.api.tools.FunctionTool;
import org.apache.flink.agents.api.tools.ToolMetadata;
import org.apache.flink.agents.api.tools.ToolParameters;
import org.apache.flink.agents.api.tools.ToolResponse;
import org.apache.flink.agents.api.tools.ToolType;

public abstract class Tool
extends SerializableResource {
    protected final ToolMetadata metadata;

    protected Tool(ToolMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata cannot be null");
    }

    public final ToolMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final ResourceType getResourceType() {
        return ResourceType.TOOL;
    }

    public abstract ToolType getToolType();

    public abstract ToolResponse call(ToolParameters var1);

    public final String getName() {
        return this.metadata.getName();
    }

    public final String getDescription() {
        return this.metadata.getDescription();
    }

    public static FunctionTool fromMethod(Method method) {
        return new FunctionTool(method);
    }
}

