/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.env;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.agents.runtime.env.EmbeddedPythonEnvironment;
import org.apache.flink.api.common.JobID;
import org.apache.flink.python.env.AbstractPythonEnvironmentManager;
import org.apache.flink.python.env.PythonDependencyInfo;
import pemja.core.PythonInterpreterConfig;

public class PythonEnvironmentManager
extends AbstractPythonEnvironmentManager {
    public PythonEnvironmentManager(PythonDependencyInfo dependencyInfo, String[] tmpDirectories, Map<String, String> systemEnv, JobID jobID) {
        super(dependencyInfo, tmpDirectories, systemEnv, jobID);
    }

    public EmbeddedPythonEnvironment createEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>(this.getPythonEnv());
        PythonInterpreterConfig.PythonInterpreterConfigBuilder interpreterConfigBuilder = PythonInterpreterConfig.newBuilder().setExcType(PythonInterpreterConfig.ExecType.MULTI_THREAD).addPythonPaths(env.getOrDefault("PYTHONPATH", ""));
        if (PythonEnvironmentManager.isPythonExecFromArchives(this.dependencyInfo.getPythonExec(), this.dependencyInfo.getArchives())) {
            interpreterConfigBuilder.setPythonHome(String.join((CharSequence)"/", (CharSequence)env.get("_PYTHON_WORKING_DIR"), this.dependencyInfo.getPythonExec().substring(0, this.dependencyInfo.getPythonExec().lastIndexOf("bin") - 1))).setPythonExec(String.join((CharSequence)"/", (CharSequence)env.get("_PYTHON_WORKING_DIR"), this.dependencyInfo.getPythonExec()));
        } else {
            interpreterConfigBuilder.setPythonExec(this.dependencyInfo.getPythonExec());
        }
        if (env.containsKey("_PYTHON_WORKING_DIR")) {
            interpreterConfigBuilder.setWorkingDirectory((String)env.get("_PYTHON_WORKING_DIR"));
        }
        return new EmbeddedPythonEnvironment(interpreterConfigBuilder.build(), env);
    }

    private static boolean isPythonExecFromArchives(String pythonExec, Map<String, String> archives) {
        int index = pythonExec.indexOf("/");
        if (index == -1) {
            index = pythonExec.length();
        }
        String pythonExecBaseDir = pythonExec.substring(0, index);
        for (Map.Entry<String, String> entry : archives.entrySet()) {
            String targetDirName;
            if (entry.getValue().contains("#")) {
                String[] filePathAndTargetDir = entry.getValue().split("#", 2);
                targetDirName = filePathAndTargetDir[1];
            } else {
                targetDirName = entry.getValue();
            }
            if (!targetDirName.equals(pythonExecBaseDir)) continue;
            return true;
        }
        return false;
    }
}

