/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.apache.avro.Schema;

public class DateTimeVisitor
extends JsonIntegerFormatVisitor.Base
implements SchemaBuilder {
    protected JsonParser.NumberType _type;
    protected JavaType _hint;
    private static final String DATE = "date";
    private static final String TIME_MILLIS = "time-millis";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String LOCAL_TIMESTAMP_MILLIS = "local-timestamp-millis";

    public DateTimeVisitor() {
    }

    public DateTimeVisitor(JavaType typeHint) {
        this._hint = typeHint;
    }

    public void numberType(JsonParser.NumberType type) {
        this._type = type;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._type == null) {
            throw new IllegalStateException("No number type indicated");
        }
        Schema schema = AvroSchemaHelper.numericAvroSchema(this._type);
        if (this._hint != null) {
            String logicalType = this.getLogicalType(schema.getType(), this._hint);
            if (logicalType != null) {
                schema.addProp("logicalType", logicalType);
            } else {
                schema.addProp("java-class", AvroSchemaHelper.getTypeId(this._hint));
            }
        }
        return schema;
    }

    private String getLogicalType(Schema.Type avroType, JavaType hint) {
        Class clazz = hint.getRawClass();
        if (OffsetDateTime.class.isAssignableFrom(clazz) && Schema.Type.LONG == avroType) {
            return TIMESTAMP_MILLIS;
        }
        if (ZonedDateTime.class.isAssignableFrom(clazz) && Schema.Type.LONG == avroType) {
            return TIMESTAMP_MILLIS;
        }
        if (Instant.class.isAssignableFrom(clazz) && Schema.Type.LONG == avroType) {
            return TIMESTAMP_MILLIS;
        }
        if (LocalDate.class.isAssignableFrom(clazz) && Schema.Type.INT == avroType) {
            return DATE;
        }
        if (LocalTime.class.isAssignableFrom(clazz) && Schema.Type.INT == avroType) {
            return TIME_MILLIS;
        }
        if (LocalDateTime.class.isAssignableFrom(clazz) && Schema.Type.LONG == avroType) {
            return LOCAL_TIMESTAMP_MILLIS;
        }
        return null;
    }
}

