/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.progress;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventNotifier;
import org.apache.cassandra.utils.progress.ProgressListener;

public abstract class ProgressEventNotifierSupport
implements ProgressEventNotifier {
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireProgressEvent(String tag, ProgressEvent event) {
        for (ProgressListener listener : this.listeners) {
            listener.progress(tag, event);
        }
    }
}

