/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.path.base;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.execution.path.base.NeoExecutionViewerTabBase;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.shared.BaseExecutionViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class NeoExecutionViewerCypherTab
extends NeoExecutionViewerTabBase {
    private Text wCypher;

    public NeoExecutionViewerCypherTab(BaseExecutionViewer viewer) {
        super(viewer);
    }

    public void addNeo4jCypherTab(CTabFolder tabFolder) {
        Image neo4jImage = GuiResource.getInstance().getImage("neo4j_cypher.svg", this.classLoader, this.iconSize, this.iconSize);
        CTabItem cypherTab = new CTabItem(tabFolder, 0);
        cypherTab.setFont(GuiResource.getInstance().getFontDefault());
        cypherTab.setText(BaseMessages.getString((Class)PKG, (String)"Neo4jPerspectiveDialog.Cypher.Tab", (String[])new String[0]));
        cypherTab.setImage(neo4jImage);
        this.wCypher = new Text((Composite)tabFolder, 2818);
        PropsUi.setLook((Widget)this.wCypher);
        this.wCypher.setFont(GuiResource.getInstance().getFontFixed());
        cypherTab.setControl((Control)this.wCypher);
        tabFolder.addListener(13, e -> {
            if (cypherTab == tabFolder.getSelection()) {
                this.refresh();
            }
        });
    }

    private void refresh() {
        Object cypher = StringUtils.isEmpty((String)this.viewer.getExecution().getParentId()) ? "This execution does not have a parent and is as such a root execution. " + Const.CR + "You can look it up like this:" + Const.CR + Const.CR : "This is the Cypher used to get the list of paths to the root execution:" + Const.CR + Const.CR;
        String rootCypher = this.getPathToRootCypher();
        String activeId = this.getActiveLogChannelId();
        cypher = (String)cypher + rootCypher.replace("$executionId", "\"" + activeId + "\"");
        ExecutionState state = this.viewer.getExecutionState();
        if (state != null) {
            cypher = (String)cypher + Const.CR + Const.CR;
            cypher = (String)cypher + "Execute this Cypher to get the paths to the lowest level failed execution nodes, if there are any:" + Const.CR + Const.CR;
            cypher = (String)cypher + this.getPathToFailedCypher();
        }
        cypher = ((String)cypher).replace("$executionId", "\"" + this.getActiveLogChannelId() + "\"");
        this.wCypher.setText((String)cypher);
    }
}

