/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class LegalHoldHeldRevisionMetadata {
    @Nonnull
    protected final String newFilename;
    @Nonnull
    protected final String originalRevisionId;
    @Nonnull
    protected final String originalFilePath;
    @Nonnull
    protected final Date serverModified;
    @Nonnull
    protected final String authorMemberId;
    @Nonnull
    protected final TeamMemberStatus authorMemberStatus;
    @Nonnull
    protected final String authorEmail;
    @Nonnull
    protected final String fileType;
    protected final long size;
    @Nonnull
    protected final String contentHash;

    public LegalHoldHeldRevisionMetadata(@Nonnull String newFilename, @Nonnull String originalRevisionId, @Nonnull String originalFilePath, @Nonnull Date serverModified, @Nonnull String authorMemberId, @Nonnull TeamMemberStatus authorMemberStatus, @Nonnull String authorEmail, @Nonnull String fileType, long size, @Nonnull String contentHash) {
        if (newFilename == null) {
            throw new IllegalArgumentException("Required value for 'newFilename' is null");
        }
        this.newFilename = newFilename;
        if (originalRevisionId == null) {
            throw new IllegalArgumentException("Required value for 'originalRevisionId' is null");
        }
        if (originalRevisionId.length() < 9) {
            throw new IllegalArgumentException("String 'originalRevisionId' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", originalRevisionId)) {
            throw new IllegalArgumentException("String 'originalRevisionId' does not match pattern");
        }
        this.originalRevisionId = originalRevisionId;
        if (originalFilePath == null) {
            throw new IllegalArgumentException("Required value for 'originalFilePath' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)?", originalFilePath)) {
            throw new IllegalArgumentException("String 'originalFilePath' does not match pattern");
        }
        this.originalFilePath = originalFilePath;
        if (serverModified == null) {
            throw new IllegalArgumentException("Required value for 'serverModified' is null");
        }
        this.serverModified = LangUtil.truncateMillis(serverModified);
        if (authorMemberId == null) {
            throw new IllegalArgumentException("Required value for 'authorMemberId' is null");
        }
        this.authorMemberId = authorMemberId;
        if (authorMemberStatus == null) {
            throw new IllegalArgumentException("Required value for 'authorMemberStatus' is null");
        }
        this.authorMemberStatus = authorMemberStatus;
        if (authorEmail == null) {
            throw new IllegalArgumentException("Required value for 'authorEmail' is null");
        }
        if (authorEmail.length() > 255) {
            throw new IllegalArgumentException("String 'authorEmail' is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", authorEmail)) {
            throw new IllegalArgumentException("String 'authorEmail' does not match pattern");
        }
        this.authorEmail = authorEmail;
        if (fileType == null) {
            throw new IllegalArgumentException("Required value for 'fileType' is null");
        }
        this.fileType = fileType;
        this.size = size;
        if (contentHash == null) {
            throw new IllegalArgumentException("Required value for 'contentHash' is null");
        }
        if (contentHash.length() < 64) {
            throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
        }
        if (contentHash.length() > 64) {
            throw new IllegalArgumentException("String 'contentHash' is longer than 64");
        }
        this.contentHash = contentHash;
    }

    @Nonnull
    public String getNewFilename() {
        return this.newFilename;
    }

    @Nonnull
    public String getOriginalRevisionId() {
        return this.originalRevisionId;
    }

    @Nonnull
    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    @Nonnull
    public Date getServerModified() {
        return this.serverModified;
    }

    @Nonnull
    public String getAuthorMemberId() {
        return this.authorMemberId;
    }

    @Nonnull
    public TeamMemberStatus getAuthorMemberStatus() {
        return this.authorMemberStatus;
    }

    @Nonnull
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Nonnull
    public String getFileType() {
        return this.fileType;
    }

    public long getSize() {
        return this.size;
    }

    @Nonnull
    public String getContentHash() {
        return this.contentHash;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.newFilename, this.originalRevisionId, this.originalFilePath, this.serverModified, this.authorMemberId, this.authorMemberStatus, this.authorEmail, this.fileType, this.size, this.contentHash});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldHeldRevisionMetadata other = (LegalHoldHeldRevisionMetadata)obj;
            return !(this.newFilename != other.newFilename && !this.newFilename.equals(other.newFilename) || this.originalRevisionId != other.originalRevisionId && !this.originalRevisionId.equals(other.originalRevisionId) || this.originalFilePath != other.originalFilePath && !this.originalFilePath.equals(other.originalFilePath) || this.serverModified != other.serverModified && !this.serverModified.equals(other.serverModified) || this.authorMemberId != other.authorMemberId && !this.authorMemberId.equals(other.authorMemberId) || this.authorMemberStatus != other.authorMemberStatus && !this.authorMemberStatus.equals(other.authorMemberStatus) || this.authorEmail != other.authorEmail && !this.authorEmail.equals(other.authorEmail) || this.fileType != other.fileType && !this.fileType.equals(other.fileType) || this.size != other.size || this.contentHash != other.contentHash && !this.contentHash.equals(other.contentHash));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldHeldRevisionMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldHeldRevisionMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("new_filename");
            StoneSerializers.string().serialize(value.newFilename, g);
            g.writeFieldName("original_revision_id");
            StoneSerializers.string().serialize(value.originalRevisionId, g);
            g.writeFieldName("original_file_path");
            StoneSerializers.string().serialize(value.originalFilePath, g);
            g.writeFieldName("server_modified");
            StoneSerializers.timestamp().serialize(value.serverModified, g);
            g.writeFieldName("author_member_id");
            StoneSerializers.string().serialize(value.authorMemberId, g);
            g.writeFieldName("author_member_status");
            TeamMemberStatus.Serializer.INSTANCE.serialize(value.authorMemberStatus, g);
            g.writeFieldName("author_email");
            StoneSerializers.string().serialize(value.authorEmail, g);
            g.writeFieldName("file_type");
            StoneSerializers.string().serialize(value.fileType, g);
            g.writeFieldName("size");
            StoneSerializers.uInt64().serialize((Long)value.size, g);
            g.writeFieldName("content_hash");
            StoneSerializers.string().serialize(value.contentHash, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LegalHoldHeldRevisionMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_contentHash;
            Long f_size;
            String f_fileType;
            String f_authorEmail;
            TeamMemberStatus f_authorMemberStatus;
            String f_authorMemberId;
            Date f_serverModified;
            String f_originalFilePath;
            String f_originalRevisionId;
            String f_newFilename;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newFilename = null;
                f_originalRevisionId = null;
                f_originalFilePath = null;
                f_serverModified = null;
                f_authorMemberId = null;
                f_authorMemberStatus = null;
                f_authorEmail = null;
                f_fileType = null;
                f_size = null;
                f_contentHash = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_filename".equals(field)) {
                        f_newFilename = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("original_revision_id".equals(field)) {
                        f_originalRevisionId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("original_file_path".equals(field)) {
                        f_originalFilePath = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("server_modified".equals(field)) {
                        f_serverModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("author_member_id".equals(field)) {
                        f_authorMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("author_member_status".equals(field)) {
                        f_authorMemberStatus = TeamMemberStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("author_email".equals(field)) {
                        f_authorEmail = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("file_type".equals(field)) {
                        f_fileType = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("content_hash".equals(field)) {
                        f_contentHash = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_newFilename == null) {
                    throw new JsonParseException(p, "Required field \"new_filename\" missing.");
                }
                if (f_originalRevisionId == null) {
                    throw new JsonParseException(p, "Required field \"original_revision_id\" missing.");
                }
                if (f_originalFilePath == null) {
                    throw new JsonParseException(p, "Required field \"original_file_path\" missing.");
                }
                if (f_serverModified == null) {
                    throw new JsonParseException(p, "Required field \"server_modified\" missing.");
                }
                if (f_authorMemberId == null) {
                    throw new JsonParseException(p, "Required field \"author_member_id\" missing.");
                }
                if (f_authorMemberStatus == null) {
                    throw new JsonParseException(p, "Required field \"author_member_status\" missing.");
                }
                if (f_authorEmail == null) {
                    throw new JsonParseException(p, "Required field \"author_email\" missing.");
                }
                if (f_fileType == null) {
                    throw new JsonParseException(p, "Required field \"file_type\" missing.");
                }
                if (f_size == null) {
                    throw new JsonParseException(p, "Required field \"size\" missing.");
                }
                if (f_contentHash == null) {
                    throw new JsonParseException(p, "Required field \"content_hash\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldHeldRevisionMetadata value = new LegalHoldHeldRevisionMetadata(f_newFilename, f_originalRevisionId, f_originalFilePath, f_serverModified, f_authorMemberId, f_authorMemberStatus, f_authorEmail, f_fileType, f_size, f_contentHash);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

