/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.io.InputStream;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.pipeline.transforms.excelinput.ods.OdfWorkbook;
import org.apache.hop.pipeline.transforms.excelinput.poi.PoiWorkbook;
import org.apache.hop.pipeline.transforms.excelinput.staxpoi.StaxPoiWorkbook;

public class WorkbookFactory {
    private WorkbookFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static IKWorkbook getWorkbook(SpreadSheetType type, String filename, String encoding, IVariables variables) throws HopException {
        switch (type) {
            case POI: {
                return new PoiWorkbook(filename, encoding, variables);
            }
            case SAX_POI: {
                return new StaxPoiWorkbook(filename, encoding, variables);
            }
            case ODS: {
                return new OdfWorkbook(filename, encoding, variables);
            }
        }
        throw new HopException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
    }

    public static IKWorkbook getWorkbook(SpreadSheetType type, InputStream inputStream, String encoding) throws HopException {
        switch (type) {
            case POI: {
                return new PoiWorkbook(inputStream, encoding);
            }
            case SAX_POI: {
                return new StaxPoiWorkbook(inputStream, encoding);
            }
            case ODS: {
                return new OdfWorkbook(inputStream, encoding);
            }
        }
        throw new HopException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
    }
}

