/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.minio.BucketArgs;
import io.minio.PutObjectFanOutEntry;
import io.minio.ServerSideEncryption;
import io.minio.messages.Checksum;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;

public class PutObjectFanOutArgs
extends BucketArgs {
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private InputStream stream;
    private long size;
    private List<PutObjectFanOutEntry> entries = null;
    private Checksum checksum;
    private ServerSideEncryption sse;

    public InputStream stream() {
        return this.stream;
    }

    public long size() {
        return this.size;
    }

    public List<PutObjectFanOutEntry> entries() {
        return this.entries;
    }

    public Checksum checksum() {
        return this.checksum;
    }

    public ServerSideEncryption sse() {
        return this.sse;
    }

    public String fanOutList() throws JsonProcessingException {
        if (this.entries == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (PutObjectFanOutEntry entry : this.entries) {
            builder.append(objectMapper.writeValueAsString((Object)entry));
        }
        return builder.toString();
    }

    public void validateSse(HttpUrl url) {
        this.checkSse(this.sse, url);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectFanOutArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutObjectFanOutArgs that = (PutObjectFanOutArgs)o;
        return Objects.equals(this.stream, that.stream) && this.size == that.size && Objects.equals(this.entries, that.entries) && Objects.equals(this.checksum, that.checksum) && Objects.equals(this.sse, that.sse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stream, this.size, this.entries, this.checksum, this.sse);
    }

    public static final class Builder
    extends BucketArgs.Builder<Builder, PutObjectFanOutArgs> {
        @Override
        protected void validate(PutObjectFanOutArgs args) {
            super.validate(args);
            this.validateNotNull(args.stream, "stream");
            this.validateNotNull(args.entries, "fan-out entries");
        }

        public Builder stream(InputStream stream, long size) {
            this.validateNotNull(stream, "stream");
            if (size < 0L) {
                throw new IllegalArgumentException("invalid stream size " + size);
            }
            if (size > 0x140000000L) {
                throw new IllegalArgumentException("size " + size + " is not supported; maximum allowed 5GiB");
            }
            this.operations.add(args -> ((PutObjectFanOutArgs)args).stream = stream);
            this.operations.add(args -> ((PutObjectFanOutArgs)args).size = size);
            return this;
        }

        public Builder entries(List<PutObjectFanOutEntry> entries) {
            this.operations.add(args -> ((PutObjectFanOutArgs)args).entries = entries);
            return this;
        }

        public Builder checksum(Checksum checksum) {
            this.operations.add(args -> ((PutObjectFanOutArgs)args).checksum = checksum);
            return this;
        }

        public Builder sse(ServerSideEncryption sse) {
            this.operations.add(args -> ((PutObjectFanOutArgs)args).sse = sse);
            return this;
        }
    }
}

