/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.field;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.bson.BsonUndefined;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;

public class MongoField
implements Comparable<MongoField> {
    protected static final Class<?> PKG = MongoField.class;
    @HopMetadataProperty(key="field_name", injectionKey="FIELD_NAME")
    public String fieldName = "";
    @HopMetadataProperty(key="field_path", injectionKey="FIELD_PATH")
    public String fieldPath = "";
    @HopMetadataProperty(key="field_type", injectionKey="FIELD_TYPE")
    public String hopType = "";
    @HopMetadataProperty(key="indexed_vals", injectionKey="FIELD_INDEXED")
    public List<String> indexedValues;
    public transient String arrayIndexInfo;
    public transient int percentageOfSample = -1;
    public transient String occurrenceFraction = "";
    public transient Class<?> mongoType;
    public transient boolean disparateTypes;
    public int outputIndex;
    private IValueMeta tempValueMeta;
    private List<String> pathParts;
    private List<String> tempParts;

    public MongoField copy() {
        MongoField newF = new MongoField();
        newF.fieldName = this.fieldName;
        newF.fieldPath = this.fieldPath;
        newF.hopType = this.hopType;
        newF.indexedValues = this.indexedValues;
        return newF;
    }

    public void init(int outputIndex) throws HopException {
        if (StringUtils.isEmpty((String)this.fieldPath)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MongoField.Error.NoPathSet", (String[])new String[0]));
        }
        if (this.pathParts != null) {
            return;
        }
        String fieldPath = MongoDbInputData.cleansePath(this.fieldPath);
        String[] temp = fieldPath.split("\\.");
        this.pathParts = new ArrayList<String>();
        Collections.addAll(this.pathParts, temp);
        if (this.pathParts.get(0).equals("$")) {
            this.pathParts.remove(0);
        } else if (this.pathParts.get(0).startsWith("$[")) {
            String r = this.pathParts.get(0).substring(1, this.pathParts.get(0).length());
            this.pathParts.set(0, r);
        }
        this.tempParts = new ArrayList<String>();
        this.tempValueMeta = ValueMetaFactory.createValueMeta((int)ValueMetaFactory.getIdForValueMeta((String)this.hopType));
        this.outputIndex = outputIndex;
    }

    public void reset(IVariables variables) {
        this.tempParts.clear();
        for (String part : this.pathParts) {
            this.tempParts.add(variables.resolve(part));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getHopValue(Object fieldValue) throws HopException {
        Object object;
        switch (this.tempValueMeta.getType()) {
            case 6: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = BigDecimal.valueOf(number.doubleValue());
                } else if (fieldValue instanceof Date) {
                    Date date = (Date)fieldValue;
                    fieldValue = new BigDecimal(date.getTime());
                } else {
                    fieldValue = new BigDecimal(fieldValue.toString());
                }
                BigDecimal bigDecimal = this.tempValueMeta.getBigNumber(fieldValue);
                object = bigDecimal;
                return object;
            }
            case 8: {
                if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    fieldValue = binary.getData();
                } else if (!(fieldValue instanceof byte[])) {
                    fieldValue = fieldValue.toString().getBytes();
                }
                byte[] byArray = this.tempValueMeta.getBinary(fieldValue);
                object = byArray;
                return object;
            }
            case 4: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = number.intValue() != 0;
                } else if (fieldValue instanceof Date) {
                    Date date = (Date)fieldValue;
                    fieldValue = date.getTime() != 0L;
                } else if (!(fieldValue instanceof Boolean)) {
                    fieldValue = fieldValue.toString().equalsIgnoreCase("Y") || fieldValue.toString().equalsIgnoreCase("T") || fieldValue.toString().equalsIgnoreCase("1");
                }
                Boolean bl = this.tempValueMeta.getBoolean(fieldValue);
                object = bl;
                return object;
            }
            case 3: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = new Date(number.longValue());
                } else if (!(fieldValue instanceof Date)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.DateConversion", (String[])new String[]{fieldValue.toString()}));
                }
                Date date = this.tempValueMeta.getDate(fieldValue);
                object = date;
                return object;
            }
            case 5: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = (long)number.intValue();
                } else if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    byte[] b = binary.getData();
                    String s = new String(b);
                    fieldValue = Long.valueOf(s);
                } else {
                    fieldValue = Long.valueOf(fieldValue.toString());
                }
                Long l = this.tempValueMeta.getInteger(fieldValue);
                object = l;
                return object;
            }
            case 1: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = number.doubleValue();
                } else if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    byte[] b = binary.getData();
                    String s = new String(b);
                    fieldValue = Double.valueOf(s);
                } else {
                    fieldValue = Double.valueOf(fieldValue.toString());
                }
                Double d = this.tempValueMeta.getNumber(fieldValue);
                object = d;
                return object;
            }
            case 2: {
                String string = this.tempValueMeta.getString(fieldValue);
                object = string;
                return object;
            }
            case 11: {
                JsonNode jsonNode = this.tempValueMeta.getJson(fieldValue);
                object = jsonNode;
                return object;
            }
        }
        try {
            int uuidTypeId = ValueMetaFactory.getIdForValueMeta((String)"UUID");
            if (this.tempValueMeta.getType() != uuidTypeId) return null;
            if (fieldValue instanceof UUID) {
                UUID uuid;
                UUID uUID = uuid = (UUID)fieldValue;
                object = uUID;
                return object;
            }
            UUID uUID = UUID.fromString(fieldValue.toString());
            object = uUID;
            return object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object convertToHopValue(Document mongoObject) throws HopException {
        Object fieldValue;
        if (mongoObject == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return null;
        }
        if (part.contains("[")) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get((Object)part)) == null || fieldValue.getClass().equals(BsonUndefined.class)) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            return this.getHopValue(fieldValue);
        }
        if (fieldValue instanceof Document) {
            Document doc = (Document)fieldValue;
            return this.convertToHopValue(doc);
        }
        if (fieldValue instanceof List) {
            List list = (List)fieldValue;
            return this.convertToHopValue(list);
        }
        return null;
    }

    public Object convertToHopValue(List<?> mongoList) throws HopException {
        if (mongoList == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return null;
        }
        String index = part.substring(1, part.indexOf(93));
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1);
            this.tempParts.add(0, part);
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return null;
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            return this.getHopValue(element);
        }
        if (element instanceof Document) {
            Document doc = (Document)element;
            return this.convertToHopValue(doc);
        }
        if (element instanceof List) {
            List list = (List)element;
            return this.convertToHopValue(list);
        }
        return null;
    }

    public String getPath() {
        String pathName = this.fieldPath.replace("$.", "");
        pathName = pathName.replaceAll("\\[([0-9]+)\\]", ".$1");
        pathName = pathName.replace("[*]", "");
        return pathName;
    }

    @Override
    public int compareTo(MongoField comp) {
        return this.fieldName.compareTo(comp.fieldName);
    }

    public void setIndexedVals(String vals) {
        this.indexedValues = MongoDbInputData.indexedValsList(vals);
    }

    public static Object toBsonFromJsonNode(JsonNode n) {
        if (n == null) {
            return null;
        }
        switch (n.getNodeType()) {
            case OBJECT: {
                Document d = new Document();
                n.fields().forEachRemaining(e -> d.put((String)e.getKey(), MongoField.toBsonFromJsonNode((JsonNode)e.getValue())));
                return d;
            }
            case ARRAY: {
                ArrayList list = new ArrayList(n.size());
                n.forEach(el -> list.add(MongoField.toBsonFromJsonNode(el)));
                return list;
            }
            case STRING: {
                return n.textValue();
            }
            case BOOLEAN: {
                return n.booleanValue();
            }
            case NUMBER: {
                if (n.isIntegralNumber()) {
                    long v = n.longValue();
                    return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE ? (long)((int)v) : v;
                }
                if (n.isBigDecimal()) {
                    return Decimal128.parse((String)n.decimalValue().toPlainString());
                }
                return n.doubleValue();
            }
            case BINARY: {
                try {
                    return new Binary(n.binaryValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n.asText();
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Generated
    public String getHopType() {
        return this.hopType;
    }

    @Generated
    public List<String> getIndexedValues() {
        return this.indexedValues;
    }

    @Generated
    public String getArrayIndexInfo() {
        return this.arrayIndexInfo;
    }

    @Generated
    public int getPercentageOfSample() {
        return this.percentageOfSample;
    }

    @Generated
    public String getOccurrenceFraction() {
        return this.occurrenceFraction;
    }

    @Generated
    public Class<?> getMongoType() {
        return this.mongoType;
    }

    @Generated
    public boolean isDisparateTypes() {
        return this.disparateTypes;
    }

    @Generated
    public int getOutputIndex() {
        return this.outputIndex;
    }

    @Generated
    public IValueMeta getTempValueMeta() {
        return this.tempValueMeta;
    }

    @Generated
    public List<String> getPathParts() {
        return this.pathParts;
    }

    @Generated
    public List<String> getTempParts() {
        return this.tempParts;
    }

    @Generated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Generated
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Generated
    public void setHopType(String hopType) {
        this.hopType = hopType;
    }

    @Generated
    public void setIndexedValues(List<String> indexedValues) {
        this.indexedValues = indexedValues;
    }

    @Generated
    public void setArrayIndexInfo(String arrayIndexInfo) {
        this.arrayIndexInfo = arrayIndexInfo;
    }

    @Generated
    public void setPercentageOfSample(int percentageOfSample) {
        this.percentageOfSample = percentageOfSample;
    }

    @Generated
    public void setOccurrenceFraction(String occurrenceFraction) {
        this.occurrenceFraction = occurrenceFraction;
    }

    @Generated
    public void setMongoType(Class<?> mongoType) {
        this.mongoType = mongoType;
    }

    @Generated
    public void setDisparateTypes(boolean disparateTypes) {
        this.disparateTypes = disparateTypes;
    }

    @Generated
    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    @Generated
    public void setTempValueMeta(IValueMeta tempValueMeta) {
        this.tempValueMeta = tempValueMeta;
    }

    @Generated
    public void setPathParts(List<String> pathParts) {
        this.pathParts = pathParts;
    }

    @Generated
    public void setTempParts(List<String> tempParts) {
        this.tempParts = tempParts;
    }
}

