/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;

public abstract class TypeSerializer<T> {
    public abstract ByteBuffer serialize(T var1);

    public abstract <V> T deserialize(V var1, ValueAccessor<V> var2);

    public final T deserialize(ByteBuffer bytes) {
        return this.deserialize(bytes, ByteBufferAccessor.instance);
    }

    public abstract <V> void validate(V var1, ValueAccessor<V> var2) throws MarshalException;

    public final void validate(ByteBuffer bytes) throws MarshalException {
        this.validate(bytes, ByteBufferAccessor.instance);
    }

    public abstract String toString(T var1);

    public abstract Class<T> getType();

    public String toCQLLiteral(ByteBuffer buffer) {
        return buffer == null || !buffer.hasRemaining() ? "null" : this.toString(this.deserialize(buffer));
    }
}

