/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Instant;

public class WindowMatchers {
    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        ArrayList windowMatchers = Lists.newArrayListWithCapacity((int)windows.size());
        for (BoundedWindow boundedWindow : windows) {
            windowMatchers.add(Matchers.equalTo((Object)boundedWindow));
        }
        return WindowMatchers.isWindowedValue(Matchers.equalTo(value), (Matcher<? super Instant>)Matchers.equalTo((Object)timestamp), (Matcher<? super Collection<? extends BoundedWindow>>)Matchers.containsInAnyOrder((Collection)windowMatchers), (Matcher<? super PaneInfo>)Matchers.equalTo((Object)paneInfo));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized PaneInfo> paneInfoMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, windowsMatcher, paneInfoMatcher);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, windowsMatcher, Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, Matchers.anything(), Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher) {
        return new WindowedValueMatcher(valueMatcher, Matchers.anything(), Matchers.anything(), Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized long windowStart, @UnknownKeyFor @NonNull @Initialized long windowEnd) {
        return WindowMatchers.isSingleWindowedValue(Matchers.equalTo(value), timestamp, windowStart, windowEnd);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return WindowMatchers.isSingleWindowedValue(Matchers.equalTo(value), (Matcher<? super Instant>)Matchers.equalTo((Object)timestamp), (Matcher<? super BoundedWindow>)Matchers.equalTo((Object)window), (Matcher<? super PaneInfo>)Matchers.equalTo((Object)paneInfo));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return WindowMatchers.isSingleWindowedValue(Matchers.equalTo(value), (Matcher<? super Instant>)Matchers.equalTo((Object)timestamp), (Matcher<? super BoundedWindow>)Matchers.equalTo((Object)window));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return WindowMatchers.isSingleWindowedValue(Matchers.equalTo(value), (Matcher<? super Instant>)Matchers.anything(), (Matcher<? super BoundedWindow>)Matchers.equalTo((Object)window), (Matcher<? super PaneInfo>)Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<T> valueMatcher, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized long windowStart, @UnknownKeyFor @NonNull @Initialized long windowEnd) {
        IntervalWindow intervalWindow = new IntervalWindow(new Instant(windowStart), new Instant(windowEnd));
        return WindowMatchers.isSingleWindowedValue(valueMatcher, (Matcher<? super Instant>)Matchers.describedAs((String)"%0", (Matcher)Matchers.equalTo((Object)new Instant(timestamp)), (Object[])new Object[]{timestamp}), (Matcher<? super BoundedWindow>)Matchers.equalTo((Object)intervalWindow), (Matcher<? super PaneInfo>)Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<T> valueMatcher, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized long windowStart, @UnknownKeyFor @NonNull @Initialized long windowEnd, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        IntervalWindow intervalWindow = new IntervalWindow(new Instant(windowStart), new Instant(windowEnd));
        return WindowMatchers.isSingleWindowedValue(valueMatcher, (Matcher<? super Instant>)Matchers.describedAs((String)"%0", (Matcher)Matchers.equalTo((Object)new Instant(timestamp)), (Object[])new Object[]{timestamp}), (Matcher<? super BoundedWindow>)Matchers.equalTo((Object)intervalWindow), (Matcher<? super PaneInfo>)Matchers.equalTo((Object)paneInfo));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, Matchers.contains(windowMatcher), Matchers.anything());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isSingleWindowedValue(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized PaneInfo> paneInfoMatcher) {
        return new WindowedValueMatcher(valueMatcher, timestampMatcher, Matchers.contains(windowMatcher), paneInfoMatcher);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized IntervalWindow> intervalWindow(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return Matchers.equalTo((Object)new IntervalWindow(new Instant(start), new Instant(end)));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> valueWithPaneInfo(final @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return new TypeSafeMatcher<WindowedValue<? extends T>>(){

            public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
                description.appendText("WindowedValue(paneInfo = ").appendValue((Object)paneInfo).appendText(")");
            }

            protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T> item) {
                return Objects.equals(item.getPaneInfo(), paneInfo);
            }

            protected void describeMismatchSafely(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T> item, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item.getPaneInfo());
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isValueInGlobalWindow(T value) {
        return WindowMatchers.isSingleWindowedValue(value, (BoundedWindow)GlobalWindow.INSTANCE);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T>> isValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return WindowMatchers.isSingleWindowedValue(value, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
    }

    @SafeVarargs
    public static final <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Iterable<W>> ofWindows(Matcher<W> ... windows) {
        return Matchers.containsInAnyOrder(windows);
    }

    private WindowMatchers() {
    }

    private static class WindowedValueMatcher<@UnknownKeyFor T>
    extends TypeSafeMatcher<WindowedValue<? extends T>> {
        private @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher;
        private @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher;
        private @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsMatcher;
        private @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized PaneInfo> paneInfoMatcher;

        private WindowedValueMatcher(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super T> valueMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Instant> timestampMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsMatcher, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized PaneInfo> paneInfoMatcher) {
            this.valueMatcher = valueMatcher;
            this.timestampMatcher = timestampMatcher;
            this.windowsMatcher = windowsMatcher;
            this.paneInfoMatcher = paneInfoMatcher;
        }

        public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
            description.appendText("a WindowedValue(").appendValue(this.valueMatcher).appendText(", ").appendValue(this.timestampMatcher).appendText(", ").appendValue(this.windowsMatcher).appendText(", ").appendValue(this.paneInfoMatcher).appendText(")");
        }

        protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ? extends T> windowedValue) {
            return this.valueMatcher.matches(windowedValue.getValue()) && this.timestampMatcher.matches((Object)windowedValue.getTimestamp()) && this.windowsMatcher.matches((Object)windowedValue.getWindows()) && this.paneInfoMatcher.matches((Object)windowedValue.getPaneInfo());
        }
    }
}

