/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.webserviceavailable;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="WEBSERVICE_AVAILABLE", name="i18n::ActionWebServiceAvailable.Name", description="i18n::ActionWebServiceAvailable.Description", image="WebServiceAvailable.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionWebServiceAvailable.keyword"}, documentationUrl="/workflow/actions/webserviceavailable.html")
public class ActionWebServiceAvailable
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWebServiceAvailable.class;
    public static final String CONST_SPACES = "      ";
    @HopMetadataProperty
    private String url = null;
    @HopMetadataProperty
    private String connectTimeOut = "0";
    @HopMetadataProperty
    private String readTimeOut = "0";

    public ActionWebServiceAvailable(String n) {
        super(n, "");
    }

    public ActionWebServiceAvailable() {
        this("");
    }

    public Object clone() {
        ActionWebServiceAvailable je = (ActionWebServiceAvailable)super.clone();
        return je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        String realURL = this.resolve(this.getUrl());
        if (!Utils.isEmpty((CharSequence)realURL)) {
            int connectTimeOut = Const.toInt((String)this.resolve(this.getConnectTimeOut()), (int)0);
            int readTimeOut = Const.toInt((String)this.resolve(this.getReadTimeOut()), (int)0);
            InputStream in = null;
            try {
                URLConnection conn = new URL(realURL).openConnection();
                conn.setConnectTimeout(connectTimeOut);
                conn.setReadTimeout(readTimeOut);
                in = conn.getInputStream();
                result.setResult(true);
            }
            catch (Exception e) {
                result.setNrErrors(1L);
                String message = BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ERROR_0004_Exception", (String[])new String[]{realURL, e.toString()});
                this.logError(message);
                result.setLogText(message);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            result.setNrErrors(1L);
            String message = BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ERROR_0005_No_URL_Defined", (String[])new String[0]);
            this.logError(message);
            result.setLogText(message);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getConnectTimeOut() {
        return this.connectTimeOut;
    }

    @Generated
    public String getReadTimeOut() {
        return this.readTimeOut;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setConnectTimeOut(String connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    @Generated
    public void setReadTimeOut(String readTimeOut) {
        this.readTimeOut = readTimeOut;
    }
}

