/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;

public class InternalKeyContextImpl<K>
implements InternalKeyContext<K> {
    private final KeyGroupRange keyGroupRange;
    private final int numberOfKeyGroups;
    private K currentKey;
    private int currentKeyGroupIndex;

    public InternalKeyContextImpl(@Nonnull KeyGroupRange keyGroupRange, @Nonnegative int numberOfKeyGroups) {
        this.keyGroupRange = keyGroupRange;
        this.numberOfKeyGroups = numberOfKeyGroups;
    }

    @Override
    public K getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public int getCurrentKeyGroupIndex() {
        return this.currentKeyGroupIndex;
    }

    @Override
    public int getNumberOfKeyGroups() {
        return this.numberOfKeyGroups;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public void setCurrentKey(@Nonnull K currentKey) {
        this.currentKey = currentKey;
    }

    @Override
    public void setCurrentKeyGroupIndex(int currentKeyGroupIndex) {
        if (!this.keyGroupRange.contains(currentKeyGroupIndex)) {
            throw KeyGroupRangeOffsets.newIllegalKeyGroupException(currentKeyGroupIndex, this.keyGroupRange);
        }
        this.currentKeyGroupIndex = currentKeyGroupIndex;
    }
}

