/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.join;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;

@Action(id="JOIN", name="i18n::ActionJoin.Name", description="i18n::ActionJoin.Description", image="join.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionJoin.Keyword"}, documentationUrl="/workflow/actions/join.html")
public class ActionJoin
extends ActionBase {
    private static final Class<?> PKG = ActionJoin.class;

    public ActionJoin(String name, String description) {
        super(name, description);
    }

    public ActionJoin() {
        this("", "");
    }

    public ActionJoin(ActionJoin other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
    }

    public Object clone() {
        return new ActionJoin(this);
    }

    public Result execute(Result result, int nr) {
        try {
            List<ActionMeta> prevActions = this.getPreviousAction((IAction)this, new ArrayList<ActionMeta>(), false);
            WorkflowTracker workflowTracker = this.parentWorkflow.getWorkflowTracker();
            while (!this.parentWorkflow.isStopped()) {
                Thread.sleep(500L);
                boolean hasAllResult = true;
                for (ActionMeta actionMeta : prevActions) {
                    WorkflowTracker tracker = workflowTracker.findWorkflowTracker(actionMeta);
                    if (tracker != null) {
                        if (tracker.getActionResult().getResult() != null) continue;
                        hasAllResult = false;
                        continue;
                    }
                    hasAllResult = false;
                }
                if (!hasAllResult) continue;
                break;
            }
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError(BaseMessages.getString(PKG, (String)"ActionJoin.Error.CouldNotExecute", (String[])new String[0]) + String.valueOf(e));
        }
        return result;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isJoin() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        List<ActionMeta> prevActions = this.getPreviousAction((IAction)this, new ArrayList<ActionMeta>(), true);
        boolean isLaunchingInParallel = false;
        for (ActionMeta actionMeta : prevActions) {
            isLaunchingInParallel |= actionMeta.isLaunchingInParallel();
        }
        if (!isLaunchingInParallel) {
            String message = BaseMessages.getString(PKG, (String)"ActionJoin.CheckResult.NoParallelExecution", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(3, message, (ICheckResultSource)this));
        }
    }

    private List<ActionMeta> getPreviousAction(IAction action, List<ActionMeta> prevActions, boolean deep) {
        List hops = this.parentWorkflowMeta.getWorkflowHops();
        for (WorkflowHopMeta hop : hops) {
            if (!hop.isEnabled() || !hop.getToAction().getName().equals(action.getName())) continue;
            ActionMeta actionMeta = hop.getFromAction();
            prevActions.add(actionMeta);
            if (!deep || actionMeta.isJoin()) continue;
            this.getPreviousAction(actionMeta.getAction(), prevActions, true);
        }
        return prevActions;
    }
}

