/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup.readallcache;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.SearchingContext;

abstract class Index {
    final int column;
    final IValueMeta valueMeta;
    final IndexedValue[] values;

    Index(int column, IValueMeta valueMeta, int rowsAmount) {
        this.column = column;
        this.valueMeta = valueMeta;
        this.values = new IndexedValue[rowsAmount];
    }

    Comparator<IndexedValue> createComparator() {
        return new IndexValueComparator(this.valueMeta);
    }

    void performIndexingOf(Object[][] rows) {
        int len = rows.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = new IndexedValue(rows[i][this.column], i);
        }
        Arrays.sort(this.values, this.createComparator());
    }

    int findInsertionPointOf(IndexedValue value) {
        int index = Arrays.binarySearch(this.values, value, this.createComparator());
        return -(index + 1);
    }

    public int getColumn() {
        return this.column;
    }

    public void applyRestrictionsTo(SearchingContext context, IValueMeta lookupMeta, Object lookupValue) {
        try {
            this.doApply(context, lookupMeta, lookupValue);
        }
        catch (HopException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void doApply(SearchingContext var1, IValueMeta var2, Object var3) throws HopException;

    abstract int getRestrictionPower();

    static Comparator<Index> restrictionComparator() {
        return (o1, o2) -> Integer.compare(o1.getRestrictionPower(), o2.getRestrictionPower());
    }

    static class IndexedValue {
        final Object key;
        final int row;

        public IndexedValue(Object key, int row) {
            this.key = key;
            this.row = row;
        }
    }

    static class IndexValueComparator
    implements Comparator<IndexedValue> {
        private final IValueMeta meta;

        public IndexValueComparator(IValueMeta meta) {
            this.meta = meta;
        }

        @Override
        public int compare(IndexedValue o1, IndexedValue o2) {
            int c;
            try {
                c = this.meta.compare(o1.key, o2.key);
            }
            catch (HopValueException e) {
                throw new RuntimeException(e);
            }
            return c == 0 ? Integer.compare(o1.row, o2.row) : c;
        }
    }
}

