/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Frame;
import com.ibm.as400.util.commtrace.Progress;
import com.ibm.as400.util.commtrace.Prolog;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

public class Format {
    private static final String ALL = "*ALL";
    private static final String NO = "*NO";
    private static final String CLASS = "Format";
    private AS400 sys;
    private boolean createdSys;
    private InputStream file_;
    private Progress progress;
    private byte[] data;
    private Prolog pro_;
    private String filename;
    private String outfilePath_;
    private BitBuf nxtRecLen;
    private int ifsrecs;
    private int tcprecs;
    private int numrecs;
    private FormatProperties filter_;
    private ObjectInputStream serin_;

    public Format() {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
    }

    public Format(AS400 sys) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.sys = sys;
    }

    public Format(FormatProperties prop, String outfile, String infile) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filter_ = prop;
        this.outfilePath_ = outfile;
        this.filename = infile;
        if (infile == null) {
            this.close();
            return;
        }
        try {
            this.file_ = new BufferedInputStream(new FileInputStream(infile));
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format()Error opening:" + infile, (Throwable)e);
            }
            this.close();
            return;
        }
        this.formatProlog();
    }

    public Format(String[] args) {
        String filename;
        String cur;
        String pwd;
        String uid;
        String system;
        CommandLineArguments arguments;
        block43: {
            String outfile;
            this.sys = null;
            this.createdSys = false;
            this.file_ = null;
            this.progress = null;
            this.data = null;
            this.pro_ = null;
            this.filename = null;
            this.outfilePath_ = null;
            this.ifsrecs = 0;
            this.tcprecs = 0;
            this.numrecs = 0;
            Vector<String> v = new Vector<String>();
            v.addElement("-userID");
            v.addElement("-password");
            v.addElement("-trace");
            v.addElement("-filename");
            v.addElement("-outfile");
            v.addElement("-current");
            v.addElement("-verbose");
            v.addElement("-logfile");
            v.addElement("-country");
            v.addElement("-language");
            v.addElement("-ipaddress");
            v.addElement("-ipaddress2");
            v.addElement("-port");
            v.addElement("-broadcast");
            v.addElement("-starttime");
            v.addElement("-endtime");
            v.addElement("-starttimelong");
            v.addElement("-endtimelong");
            Hashtable<String, String> shortcuts = new Hashtable<String, String>();
            shortcuts.put("-u", "-userID");
            shortcuts.put("-p", "-password");
            shortcuts.put("-t", "-trace");
            shortcuts.put("-o", "-outfile");
            shortcuts.put("-c", "-current");
            shortcuts.put("-v", "-verbose");
            shortcuts.put("-l", "-language");
            shortcuts.put("-co", "-country");
            shortcuts.put("-ip", "-ipaddress");
            shortcuts.put("-ip2", "-ipaddress2");
            arguments = new CommandLineArguments(args, v, shortcuts);
            system = arguments.getOptionValue("");
            uid = arguments.getOptionValue("-userID");
            pwd = arguments.getOptionValue("-password");
            cur = arguments.getOptionValue("-current");
            this.filename = filename = arguments.getOptionValue("-trace");
            this.outfilePath_ = outfile = arguments.getOptionValue("-outfile");
            String verbose = arguments.getOptionValue("-verbose");
            String logfile = arguments.getOptionValue("-logfile");
            String country = arguments.getOptionValue("-country");
            if (verbose != null && verbose.equals("true")) {
                Trace.setTraceErrorOn(true);
                Trace.setTraceWarningOn(true);
                Trace.setTraceInformationOn(true);
                Trace.setTraceOn(true);
            }
            if (logfile != null) {
                try {
                    Trace.setFileName(logfile);
                }
                catch (IOException e) {
                    if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block43;
                    Trace.log(2, "Format.FormatCan't set trace file name, defaulting to outputing trace data to standard out");
                }
            }
        }
        this.filter_ = new FormatProperties();
        String filterIP = arguments.getOptionValue("-ipaddress");
        String filterIP2 = arguments.getOptionValue("-ipaddress2");
        String filterPort = arguments.getOptionValue("-port");
        String filterBdcst = arguments.getOptionValue("-broadcast");
        String filterSTime = arguments.getOptionValue("-starttime");
        String filterETime = arguments.getOptionValue("-endtime");
        String filterSTimelong = arguments.getOptionValue("-starttimelong");
        String filterETimelong = arguments.getOptionValue("-endtimelong");
        boolean setUpFilters = false;
        if (filterIP != null && !filterIP.equals(ALL)) {
            this.filter_.setIPAddress(filterIP);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (filterIP2 != null && !filterIP2.equals(ALL)) {
            this.filter_.setSecondIPAddress(filterIP2);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (filterBdcst != null && !filterBdcst.equals(ALL)) {
            this.filter_.setBroadcast(filterBdcst);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Broadcast Filtering enabled");
            }
        }
        if (filterPort != null && !filterPort.equals(ALL)) {
            this.filter_.setPort(filterPort);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Port Filtering enabled");
            }
        }
        if (filterSTime != null && !filterSTime.equals(ALL)) {
            this.filter_.setStartTime(filterSTime);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
            setUpFilters = true;
        }
        if (filterETime != null && !filterETime.equals(ALL)) {
            this.filter_.setEndTime(filterETime);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (filterSTimelong != null && !filterSTimelong.equals(ALL)) {
            if (filterETime != null) {
                Object time = null;
                this.filter_.setEndTime(null);
            }
            this.filter_.setStartTime(filterSTimelong);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
        }
        if (filterETimelong != null && !filterETimelong.equals(ALL)) {
            this.filter_.setEndTime(filterETimelong);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (filename == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Outfile not specified");
            }
            return;
        }
        if (cur != null) {
            this.sys = new AS400();
            this.createdSys = true;
            try {
                this.file_ = new IFSFileInputStream(this.sys, filename);
            }
            catch (FileNotFoundException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + filename + " not found", (Throwable)e);
                }
                return;
            }
            catch (IOException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Error opening " + filename, (Throwable)e);
                }
                return;
            }
            catch (AS400SecurityException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Security exception opening file", (Throwable)e);
                }
                return;
            }
        }
        if (system == null || uid == null || pwd == null) {
            try {
                this.file_ = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + filename + " not found", (Throwable)e);
                }
                return;
            }
        }
        this.sys = new AS400(system, uid, pwd);
        this.createdSys = true;
        try {
            this.file_ = new IFSFileInputStream(this.sys, filename);
        }
        catch (FileNotFoundException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + filename + " not found", (Throwable)e);
            }
            return;
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Error opening" + filename, (Throwable)e);
            }
            return;
        }
        catch (AS400SecurityException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Security exception opening file", (Throwable)e);
            }
            return;
        }
        if (!this.formatProlog() && setUpFilters) {
            this.setUpFilters();
        }
    }

    public Format(String filename) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filename = filename;
        if (filename == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File not specified");
            }
            return;
        }
        try {
            this.file_ = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + filename + " not found", (Throwable)e);
            }
            return;
        }
    }

    public Format(IFSFileInputStream file) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.file_ = file;
        this.formatProlog();
    }

    private void setUpFilters() {
        block6: {
            if (this.filter_ == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.setUpFilters() Filters are not initialized");
                }
                return;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("MMddyyyykkmmssSSS");
                String starttime = this.filter_.getStartTime();
                String endtime = this.filter_.getEndTime();
                if (starttime != null) {
                    this.filter_.setStartTime(Long.toString(df.parse(starttime).getTime()));
                }
                if (endtime != null) {
                    this.filter_.setEndTime(Long.toString(df.parse(endtime).getTime()));
                }
            }
            catch (ParseException e) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block6;
                Trace.log(2, "Format.setUpFilters() Invalid Time argument", (Throwable)e);
            }
        }
    }

    public void setFilterProperties(FormatProperties prop) {
        this.filter_ = prop;
    }

    public void setOutFile(String outfile) {
        this.outfilePath_ = outfile;
    }

    public void setInFileStream(InputStream infile) {
        this.file_ = infile;
    }

    public void setSystem(AS400 system) {
        this.sys = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int toIFSTxtFile() {
        block33: {
            if (this.sys == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSTxtFile() Error the system wasn't specified");
                }
                return 1;
            }
            if (this.outfilePath_ == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSTxtFile() Error the out file wasn't specified");
                }
                return 1;
            }
            IFSFileOutputStream out = null;
            try {
                try {
                    out = new IFSTextFileOutputStream(this.sys, this.outfilePath_);
                }
                catch (IOException e) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSTxtFile() Error opening " + this.outfilePath_, (Throwable)e);
                    }
                    int n = 1;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            Trace.log(2, e2);
                        }
                    }
                    return n;
                }
                catch (AS400SecurityException e) {
                    int n;
                    block32: {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSTxtFile() Security exception opening file", (Throwable)e);
                        }
                        n = 1;
                        if (out == null) break block32;
                        try {
                            out.close();
                        }
                        catch (IOException e3) {
                            Trace.log(2, e3);
                        }
                    }
                    return n;
                }
                int recPrinted = 0;
                try {
                    Frame rec;
                    ((IFSTextFileOutputStream)out).write(this.pro_.toString());
                    while ((rec = this.getNextRecord()) != null) {
                        if (recPrinted % 5 == 0) {
                            ((IFSTextFileOutputStream)out).write(this.addBanner());
                        }
                        ((IFSTextFileOutputStream)out).write(rec.toString());
                        ++recPrinted;
                    }
                    ((IFSTextFileOutputStream)out).write(this.addEndBanner());
                    break block33;
                }
                catch (IOException e) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSTxtFile() Error writing to " + this.filename, (Throwable)e);
                    }
                    int n = 1;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e4) {
                            Trace.log(2, e4);
                        }
                    }
                    return n;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Trace.log(2, e);
                    }
                }
            }
        }
        return 0;
    }

    public int toLclTxtFile() {
        BufferedWriter out;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error the out file wasn't specified");
            }
            return 1;
        }
        try {
            out = new BufferedWriter(new FileWriter(this.outfilePath_));
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error opening " + this.outfilePath_, (Throwable)e);
            }
            return 1;
        }
        int recPrinted = 0;
        try {
            Frame rec;
            out.write(this.pro_.toString());
            while ((rec = this.getNextRecord()) != null) {
                if (recPrinted % 5 == 0) {
                    out.write(this.addBanner());
                }
                out.write(rec.toString());
                ++recPrinted;
            }
            out.write(this.addEndBanner());
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error writing to " + this.filename, (Throwable)e);
            }
            return 1;
        }
        try {
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error closing " + this.filename, (Throwable)e);
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int toIFSBinFile() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Not a valid IBM i CommTrace");
            }
            return 1;
        }
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new IFSFileOutputStream(this.sys, this.outfilePath_));
            }
            catch (IOException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSBinFile() Error opening " + this.outfilePath_, (Throwable)e);
                }
                int n = 1;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)e2);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (AS400SecurityException e) {
                int n;
                block41: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Security exception opening file " + this.outfilePath_, (Throwable)e);
                    }
                    n = 1;
                    if (out == null) break block41;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)e3);
                        }
                        return 1;
                    }
                }
                return n;
            }
            try {
                out.writeUTF(this.pro_.toString());
                out.writeInt(this.ifsrecs);
                Frame rec = null;
                while ((rec = this.getNextRecord()) != null) {
                    String record = rec.toString(this.filter_);
                    if (record.length() == 0) continue;
                    out.writeUTF(record);
                }
                out.writeUTF(this.addEndBanner());
            }
            catch (NotSerializableException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSBinFile() Error object not serializable " + this.outfilePath_, (Throwable)e);
                }
                int n = 1;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e4) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)e4);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (IOException e) {
                int n;
                block43: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Error writing file " + this.outfilePath_, (Throwable)e);
                    }
                    n = 1;
                    if (out == null) break block43;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e5) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)e5);
                        }
                        return 1;
                    }
                }
                return n;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)e);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toLclBinFile() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Not a valid IBM i CommTrace");
            }
            return 1;
        }
        String showprogress = this.filter_.getProgress();
        if (showprogress != null && showprogress.equals("True")) {
            this.progress = new Progress("Formating " + this.filename, this.ifsrecs, " records");
            Thread progThread = new Thread((Runnable)this.progress, "ProgDiag");
            this.progress.setThread(progThread);
            progThread.start();
        }
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new FileOutputStream(this.outfilePath_));
            }
            catch (IOException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toLclBinFile() Error opening " + this.outfilePath_, (Throwable)e);
                }
                int n = 1;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)e2);
                        }
                        return 1;
                    }
                }
                return n;
            }
            try {
                out.writeUTF(this.pro_.toString());
                out.writeInt(this.ifsrecs);
                Frame rec = null;
                if (this.progress == null) {
                    while ((rec = this.getNextRecord()) != null) {
                        String record = rec.toString(this.filter_);
                        if (record.length() == 0) continue;
                        out.writeUTF(record);
                    }
                } else {
                    while ((rec = this.getNextRecord()) != null && !this.progress.isCanceled()) {
                        String record = rec.toString(this.filter_);
                        if (record.length() == 0) continue;
                        out.writeUTF(record);
                    }
                }
                out.writeUTF(this.addEndBanner());
            }
            catch (NotSerializableException e) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toLclBinFile() Error object not serializable " + this.outfilePath_, (Throwable)e);
                }
                int n = 1;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)e3);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (IOException e) {
                int n;
                block40: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toLclBinFile() Error writing file " + this.outfilePath_, (Throwable)e);
                    }
                    n = 1;
                    if (out == null) break block40;
                    try {
                        out.close();
                    }
                    catch (IOException e4) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)e4);
                        }
                        return 1;
                    }
                }
                return n;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)e);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    public int openIFSFile() {
        return this.openIFSFile(this.outfilePath_);
    }

    public int openIFSFile(String outfile) {
        this.outfilePath_ = outfile;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin_ = new ObjectInputStream(new IFSFileInputStream(this.sys, this.outfilePath_));
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Error opening " + this.outfilePath_, (Throwable)e);
            }
            return 1;
        }
        catch (AS400SecurityException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Security exception opening file " + this.outfilePath_, (Throwable)e);
            }
            return 1;
        }
        return 0;
    }

    public int openLclFile() {
        return this.openLclFile(this.outfilePath_);
    }

    public int openLclFile(String outfile) {
        this.outfilePath_ = outfile;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin_ = new ObjectInputStream(new FileInputStream(this.outfilePath_));
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Error opening " + this.outfilePath_, (Throwable)e);
            }
            return 1;
        }
        return 0;
    }

    public int close() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Format.close()");
        }
        int result = 0;
        try {
            if (this.file_ != null) {
                this.file_.close();
            }
        }
        catch (Throwable e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.filename, e);
            }
            return 1;
        }
        try {
            if (this.serin_ != null) {
                this.serin_.close();
            }
            if (this.sys != null && this.createdSys) {
                this.sys.disconnectAllServices();
            }
        }
        catch (Throwable e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.outfilePath_, e);
            }
            return 1;
        }
        if (this.progress != null) {
            this.progress.setThread(null);
        }
        return result;
    }

    public String getRecFromFile() {
        String utf = null;
        try {
            utf = this.serin_.readUTF();
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error reading file", (Throwable)e);
            }
            return null;
        }
        catch (NullPointerException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error file not opened ", (Throwable)e);
            }
            return null;
        }
        return utf;
    }

    public int getIntFromFile() {
        int tmp = 0;
        try {
            tmp = this.serin_.readInt();
        }
        catch (IOException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error reading file", (Throwable)e);
            }
            return -1;
        }
        catch (NullPointerException e) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error file not opened", (Throwable)e);
            }
            return -1;
        }
        return tmp;
    }

    public boolean formatProlog() {
        if (this.file_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.formatProlog() Input file not opened");
            }
            return false;
        }
        this.read(0, 258);
        BitBuf bb = new BitBuf(this.data);
        this.nxtRecLen = new BitBuf(bb, 2048, 16);
        this.pro_ = new Prolog(bb, this.filter_);
        this.ifsrecs = this.pro_.getNumRecs();
        return this.pro_.invalidData();
    }

    public Frame getNextRecord() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getNextRecord() Prolog not formatted.");
            }
            return null;
        }
        if (!this.pro_.invalidData()) {
            Frame rec = this.getNext();
            while (rec != null) {
                if (!rec.isTCP()) {
                    rec = this.getNext();
                    continue;
                }
                ++this.tcprecs;
                return rec;
            }
            return rec;
        }
        return null;
    }

    private Frame getNext() {
        int recLen = 0;
        if (this.progress != null) {
            this.progress.updateProgress(this.numrecs);
        }
        if (this.numrecs < this.ifsrecs) {
            BitBuf bb;
            ++this.numrecs;
            if (this.numrecs == this.ifsrecs) {
                this.read(0, this.nxtRecLen.toInt());
                bb = new BitBuf(this.data);
                recLen = (this.nxtRecLen.toInt() - 2) * 8;
            } else {
                this.read(0, this.nxtRecLen.toInt());
                bb = new BitBuf(this.data);
                recLen = this.nxtRecLen.toInt() * 8 - 16;
                this.nxtRecLen = new BitBuf(bb, recLen, 16);
            }
            return new Frame(this.pro_, bb.slice(0, recLen));
        }
        return null;
    }

    private void read(int off, int len) {
        int bytesRead;
        block3: {
            this.data = new byte[off + len];
            bytesRead = 0;
            try {
                bytesRead = this.file_.read(this.data, off, len);
            }
            catch (IOException e) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block3;
                Trace.log(2, "Format.read() Error reading file", (Throwable)e);
            }
        }
        if (bytesRead != len && Trace.isTraceOn() && Trace.isTraceErrorOn()) {
            Trace.log(2, "Format.read() Incorrect number of bytes read: Requested " + len + ", got " + bytesRead);
        }
    }

    public String addBanner() {
        StringBuilder banner = new StringBuilder();
        String record = ResourceBundleLoader_ct.getText("Record");
        String mac = ResourceBundleLoader_ct.getText("MACAddress");
        banner.append(this.pro_.getTitle());
        banner.append(this.pro_.getDate());
        banner.append(record);
        banner.append("       ");
        banner.append(ResourceBundleLoader_ct.getText("Data"));
        banner.append("      ");
        banner.append(record);
        banner.append("                     ");
        banner.append(ResourceBundleLoader_ct.getText("Destination"));
        banner.append("     ");
        banner.append(ResourceBundleLoader_ct.getText("Source"));
        banner.append("           ");
        banner.append(ResourceBundleLoader_ct.getText("Frame"));
        banner.append("\n");
        banner.append(ResourceBundleLoader_ct.getText("Number"));
        banner.append("  ");
        banner.append(ResourceBundleLoader_ct.getText("S/R"));
        banner.append("  ");
        banner.append(ResourceBundleLoader_ct.getText("Length"));
        banner.append("    ");
        banner.append(ResourceBundleLoader_ct.getText("Timer"));
        banner.append("                      ");
        banner.append(mac);
        banner.append("     ");
        banner.append(mac);
        banner.append("      ");
        banner.append(ResourceBundleLoader_ct.getText(CLASS));
        banner.append("\n");
        banner.append("------  ---  ------    ------------               --------------  --------------   ------");
        banner.append("\n");
        return banner.toString();
    }

    private String addEndBanner() {
        return "\n* * * * * * * * * * * * *    " + ResourceBundleLoader_ct.getText("EOCP") + "    * * * * * * * * * * * * *\n";
    }

    public int getRecsProcessed() {
        return this.numrecs;
    }

    public Prolog getProlog() {
        return this.pro_;
    }

    public int getNumberOfTCPRecords() {
        return this.tcprecs;
    }

    public static void main(String[] args) {
        Format f = new Format(args);
        f.toIFSBinFile();
    }
}

