/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.gen;

import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Algorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWK;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.KeyOperation;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.KeyUse;

public abstract class JWKGenerator<T extends JWK> {
    protected KeyUse use;
    protected Set<KeyOperation> ops;
    protected Algorithm alg;
    protected String kid;
    protected boolean x5tKid;
    protected Date exp;
    protected Date nbf;
    protected Date iat;
    protected KeyStore keyStore;
    protected Provider provider;
    protected SecureRandom secureRandom;

    public JWKGenerator<T> keyUse(KeyUse use) {
        this.use = use;
        return this;
    }

    public JWKGenerator<T> keyOperations(Set<KeyOperation> ops) {
        this.ops = ops;
        return this;
    }

    public JWKGenerator<T> algorithm(Algorithm alg) {
        this.alg = alg;
        return this;
    }

    public JWKGenerator<T> keyID(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKGenerator<T> keyIDFromThumbprint(boolean x5tKid) {
        this.x5tKid = x5tKid;
        return this;
    }

    public JWKGenerator<T> expirationTime(Date exp) {
        this.exp = exp;
        return this;
    }

    public JWKGenerator<T> notBeforeTime(Date nbf) {
        this.nbf = nbf;
        return this;
    }

    public JWKGenerator<T> issueTime(Date iat) {
        this.iat = iat;
        return this;
    }

    public JWKGenerator<T> keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public JWKGenerator<T> provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public JWKGenerator<T> secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public abstract T generate() throws JOSEException;
}

