/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.auth.oauth2;

import java.io.Serializable;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ExternalAccountCredentials;
import net.snowflake.client.jdbc.internal.google.errorprone.annotations.CanIgnoreReturnValue;

public class ExternalAccountSupplierContext
implements Serializable {
    private static final long serialVersionUID = -7852130853542313494L;
    private final String audience;
    private final String subjectTokenType;

    private ExternalAccountSupplierContext(Builder builder) {
        this.audience = builder.audience;
        this.subjectTokenType = builder.subjectTokenType;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        protected String audience;
        protected String subjectTokenType;

        Builder() {
        }

        @CanIgnoreReturnValue
        Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setSubjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setSubjectTokenType(ExternalAccountCredentials.SubjectTokenTypes subjectTokenType) {
            this.subjectTokenType = subjectTokenType.value;
            return this;
        }

        ExternalAccountSupplierContext build() {
            return new ExternalAccountSupplierContext(this);
        }
    }
}

