/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryInfo;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryPolicy;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryPolicyFactory;

public final class RetryLinearRetry
extends RetryPolicy
implements RetryPolicyFactory {
    public RetryLinearRetry() {
        this(30000, 3);
    }

    public RetryLinearRetry(int deltaBackoff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
    }

    @Override
    public RetryPolicy createInstance(OperationContext opContext) {
        return new RetryLinearRetry(this.deltaBackoffIntervalInMs, this.maximumAttempts);
    }

    @Override
    public RetryInfo evaluate(RetryContext retryContext, OperationContext operationContext) {
        boolean secondaryNotFound = this.evaluateLastAttemptAndSecondaryNotFound(retryContext);
        if (retryContext.getCurrentRetryCount() < this.maximumAttempts) {
            int statusCode = retryContext.getLastRequestResult().getStatusCode();
            if (!secondaryNotFound && statusCode >= 300 && statusCode < 500 && statusCode != 408 || statusCode == 501 || statusCode == 505) {
                return null;
            }
            long retryInterval = Math.max(Math.min(this.deltaBackoffIntervalInMs, 90000), 3000);
            return this.evaluateRetryInfo(retryContext, secondaryNotFound, retryInterval);
        }
        return null;
    }
}

