/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data;

import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.Data;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoublePointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.GaugeData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.HistogramData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.MetricDataType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.SumData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.SummaryData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

@Immutable
public interface MetricData {
    public Resource getResource();

    public InstrumentationScopeInfo getInstrumentationScopeInfo();

    public String getName();

    public String getDescription();

    public String getUnit();

    public MetricDataType getType();

    public Data<?> getData();

    default public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    default public GaugeData<DoublePointData> getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public GaugeData<LongPointData> getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public SumData<DoublePointData> getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (ImmutableSumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SumData<LongPointData> getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (SumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SummaryData getSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (SummaryData)this.getData();
        }
        return ImmutableSummaryData.empty();
    }

    default public HistogramData getHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (HistogramData)this.getData();
        }
        return ImmutableHistogramData.empty();
    }

    default public ExponentialHistogramData getExponentialHistogramData() {
        if (this.getType() == MetricDataType.EXPONENTIAL_HISTOGRAM) {
            return (ExponentialHistogramData)this.getData();
        }
        return ImmutableExponentialHistogramData.empty();
    }
}

