/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Objects;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.summary.ServerInfo;

public class InternalServerInfo
implements ServerInfo {
    private static final String TO_STRING_FMT = "%s{address='%s'}";
    private final String agent;
    private final String address;
    private final String protocolVersion;

    public InternalServerInfo(String agent, BoltServerAddress address, BoltProtocolVersion protocolVersion) {
        this.agent = agent;
        this.address = address.toString();
        this.protocolVersion = protocolVersion.toString();
    }

    @Override
    public String agent() {
        return this.agent;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String protocolVersion() {
        return this.protocolVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalServerInfo that = (InternalServerInfo)o;
        return Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return String.format(TO_STRING_FMT, this.getClass().getSimpleName(), this.address);
    }
}

