/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import org.apache.hop.core.util.Assert;
import org.apache.hop.core.util.BooleanPluginProperty;
import org.apache.hop.core.util.IntegerPluginProperty;
import org.apache.hop.core.util.KeyValueSet;
import org.apache.hop.core.util.StringListPluginProperty;
import org.apache.hop.core.util.StringPluginProperty;

public class PluginPropertyFactory {
    private final KeyValueSet properties;

    public PluginPropertyFactory(KeyValueSet properties) throws IllegalArgumentException {
        Assert.assertNotNull(properties, "Properties cannot be null");
        this.properties = properties;
    }

    public KeyValueSet getProperties() {
        return this.properties;
    }

    public StringPluginProperty createString(String key) throws IllegalArgumentException {
        StringPluginProperty property = new StringPluginProperty(key);
        this.properties.add(property);
        return property;
    }

    public IntegerPluginProperty createInteger(String key) throws IllegalArgumentException {
        IntegerPluginProperty property = new IntegerPluginProperty(key);
        this.properties.add(property);
        return property;
    }

    public BooleanPluginProperty createBoolean(String key) throws IllegalArgumentException {
        BooleanPluginProperty property = new BooleanPluginProperty(key);
        this.properties.add(property);
        return property;
    }

    public StringListPluginProperty createStringList(String key) throws IllegalArgumentException {
        StringListPluginProperty property = new StringListPluginProperty(key);
        this.properties.add(property);
        return property;
    }
}

