/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.ProjectName;
import com.google.cloud.secretmanager.v1.Replication;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.beam.sdk.util.Secret;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpHsmGeneratedSecret
implements Secret {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GcpHsmGeneratedSecret.class);
    private final @UnknownKeyFor @NonNull @Initialized String projectId;
    private final @UnknownKeyFor @NonNull @Initialized String locationId;
    private final @UnknownKeyFor @NonNull @Initialized String keyRingId;
    private final @UnknownKeyFor @NonNull @Initialized String keyId;
    private final @UnknownKeyFor @NonNull @Initialized String secretId;
    private final @UnknownKeyFor @NonNull @Initialized SecureRandom random = new SecureRandom();

    public GcpHsmGeneratedSecret(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String locationId, @UnknownKeyFor @NonNull @Initialized String keyRingId, @UnknownKeyFor @NonNull @Initialized String keyId, @UnknownKeyFor @NonNull @Initialized String jobName) {
        this.projectId = projectId;
        this.locationId = locationId;
        this.keyRingId = keyRingId;
        this.keyId = keyId;
        this.secretId = "HsmGeneratedSecret_" + jobName;
    }

    /*
     * Loose catch block
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSecretBytes() {
        byte[] byArray;
        SecretVersionName secretVersionName;
        SecretManagerServiceClient client;
        block18: {
            client = SecretManagerServiceClient.create();
            secretVersionName = SecretVersionName.of((String)this.projectId, (String)this.secretId, (String)"1");
            AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
            byArray = response.getPayload().getData().toByteArray();
            if (client == null) break block18;
            client.close();
        }
        return byArray;
        {
            catch (NotFoundException e) {
                byte[] byArray2;
                byte[] newKey;
                SecretName secretName;
                block19: {
                    LOG.info("Secret version {} not found. Creating new secret and version.", (Object)secretVersionName.toString());
                    ProjectName projectName = ProjectName.of((String)this.projectId);
                    secretName = SecretName.of((String)this.projectId, (String)this.secretId);
                    try {
                        com.google.cloud.secretmanager.v1.Secret secret = com.google.cloud.secretmanager.v1.Secret.newBuilder().setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.newBuilder().build())).build();
                        client.createSecret(projectName, this.secretId, secret);
                    }
                    catch (AlreadyExistsException e2) {
                        LOG.info("Secret {} already exists. Adding new version.", (Object)secretName.toString());
                    }
                    newKey = this.generateDek();
                    AccessSecretVersionResponse response2 = client.accessSecretVersion(secretVersionName);
                    byArray2 = response2.getPayload().getData().toByteArray();
                    if (client == null) break block19;
                    client.close();
                }
                return byArray2;
                {
                    catch (NotFoundException e3) {
                        byte[] byArray3;
                        block20: {
                            try {
                                LOG.info("Secret version {} not found after re-check. Creating new secret and version.", (Object)secretVersionName.toString());
                                SecretPayload payload = SecretPayload.newBuilder().setData(ByteString.copyFrom((byte[])newKey)).build();
                                client.addSecretVersion(secretName, payload);
                                AccessSecretVersionResponse response3 = client.accessSecretVersion(secretVersionName);
                                byArray3 = response3.getPayload().getData().toByteArray();
                                if (client == null) break block20;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (client != null) {
                                        try {
                                            client.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException | GeneralSecurityException e4) {
                                    throw new RuntimeException("Failed to retrieve or create secret bytes", e4);
                                }
                            }
                            client.close();
                        }
                        return byArray3;
                    }
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] generateDek() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized GeneralSecurityException {
        int dekSize = 32;
        try (KeyManagementServiceClient client = KeyManagementServiceClient.create();){
            byte[] nonceOne = new byte[dekSize];
            this.random.nextBytes(nonceOne);
            CryptoKeyName keyName = CryptoKeyName.of((String)this.projectId, (String)this.locationId, (String)this.keyRingId, (String)this.keyId);
            EncryptResponse response = client.encrypt((ResourceName)keyName, ByteString.copyFrom((byte[])nonceOne));
            byte[] nonceTwo = response.getCiphertext().toByteArray();
            byte[] dk = new byte[dekSize];
            this.random.nextBytes(dk);
            byte[] dek = Hkdf.computeHkdf((String)"HmacSha256", (byte[])dk, (byte[])nonceTwo, (byte[])new byte[0], (int)dekSize);
            byte[] byArray = Base64.getUrlEncoder().encode(dek);
            return byArray;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String getProjectId() {
        return this.projectId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getLocationId() {
        return this.locationId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getKeyRingId() {
        return this.keyRingId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getKeyId() {
        return this.keyId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSecretId() {
        return this.secretId;
    }
}

