/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;

public enum GraphPropertyDataType {
    String("string"),
    Integer("long"),
    Float("double"),
    Number("doubler"),
    Boolean("boolean"),
    Date("date"),
    LocalDateTime("localdatetime"),
    ByteArray(null),
    Time("time"),
    Point(null),
    Duration("duration"),
    LocalTime("localtime"),
    DateTime("datetime"),
    List("List"),
    Map("Map"),
    Node("Node"),
    Relationship("Relationship"),
    Path("Path");

    private String importType;

    private GraphPropertyDataType(String importType) {
        this.importType = importType;
    }

    public static String getCode(GraphPropertyDataType type) {
        if (type == null) {
            return null;
        }
        return type.name();
    }

    public static GraphPropertyDataType parseCode(String code) {
        if (code == null) {
            return String;
        }
        for (GraphPropertyDataType type : GraphPropertyDataType.values()) {
            if (!type.name().equalsIgnoreCase(code)) continue;
            return type;
        }
        return String;
    }

    public static String[] getNames() {
        String[] names = new String[GraphPropertyDataType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = GraphPropertyDataType.values()[i].name();
        }
        return names;
    }

    public static GraphPropertyDataType getTypeFromNeo4jValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return Integer;
        }
        if (object instanceof Double) {
            return Float;
        }
        if (object instanceof Number) {
            return Number;
        }
        if (object instanceof String) {
            return String;
        }
        if (object instanceof Boolean) {
            return Boolean;
        }
        if (object instanceof LocalDate) {
            return Date;
        }
        if (object instanceof LocalDateTime) {
            return LocalDateTime;
        }
        if (object instanceof LocalTime) {
            return LocalTime;
        }
        if (object instanceof Duration) {
            return Duration;
        }
        throw new RuntimeException("Unsupported object with class: " + object.getClass().getName());
    }

    public Object convertFromHop(IValueMeta valueMeta, Object valueData) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            return null;
        }
        return switch (this) {
            case String -> valueMeta.getString(valueData);
            case Boolean -> valueMeta.getBoolean(valueData);
            case Float -> valueMeta.getNumber(valueData);
            case Integer -> valueMeta.getInteger(valueData);
            case Date -> valueMeta.getDate(valueData).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            case LocalDateTime -> valueMeta.getDate(valueData).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            case ByteArray -> valueMeta.getBinary(valueData);
            default -> throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' from value '" + valueMeta.toStringMeta() + "' is not supported yet");
        };
    }

    public int getHopType() throws HopValueException {
        return switch (this) {
            case String, Map, List -> 2;
            case Node, Relationship, Path -> 303;
            case Boolean -> 4;
            case Float -> 1;
            case Integer -> 5;
            case Date, LocalDateTime -> 3;
            case ByteArray -> 8;
            default -> throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' is not supported yet");
        };
    }

    public static final GraphPropertyDataType getTypeFromHop(IValueMeta valueMeta) {
        return switch (valueMeta.getType()) {
            case 2 -> String;
            case 1 -> Float;
            case 3 -> LocalDateTime;
            case 9 -> LocalDateTime;
            case 4 -> Boolean;
            case 8 -> ByteArray;
            case 6 -> String;
            case 5 -> Integer;
            default -> String;
        };
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }
}

