/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfo;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoField;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoMeta;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoTypes;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GetLoggingInfoDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = GetLoggingInfo.class;
    private Text wTransformName;
    private TableView wFields;
    private GetLoggingInfoMeta input;
    private boolean isReceivingInput = false;

    public GetLoggingInfoDialog(Shell parent, IVariables variables, GetLoggingInfoMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.isReceivingInput = !this.pipelineMeta.findPreviousTransforms(this.transformMeta).isEmpty();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformname = new FormData();
        fdlTransformname.left = new FormAttachment(0, 0);
        fdlTransformname.right = new FormAttachment(middle, -margin);
        fdlTransformname.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformname);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformname = new FormData();
        fdTransformname.left = new FormAttachment(middle, 0);
        fdTransformname.top = new FormAttachment(0, margin);
        fdTransformname.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformname);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.input.getFields().size();
        final String[] functionDesc = new String[GetLoggingInfoTypes.values().length - 1];
        for (int i = 1; i < GetLoggingInfoTypes.values().length; ++i) {
            functionDesc[i - 1] = GetLoggingInfoTypes.values()[i].lookupDescription();
        }
        ColumnInfo[] colinf = new ColumnInfo[3];
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NameColumn.Column", (String[])new String[0]), 1, false);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.TypeColumn.Column", (String[])new String[0]), 1, false);
        colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(GetLoggingInfoDialog.this.shell, functionDesc, BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.SelectInfoType.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.SelectInfoType.DialogMessage", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                }
                GetLoggingInfoDialog.this.input.setChanged();
            }
        });
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ArgumentColumn.Column", (String[])new String[0]), 1, false);
        colinf[2].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)this.input.getFields().get(i).getFieldName(), (String)""));
            item.setText(2, Const.NVL((String)this.input.getFields().get(i).getFieldType(), (String)""));
            item.setText(3, Const.NVL((String)this.input.getFields().get(i).getFieldArgument(), (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(GetLoggingInfoMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        int count = this.wFields.nrNonEmpty();
        in.getFields().clear();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            GetLoggingInfoField field = new GetLoggingInfoField();
            field.setFieldName(item.getText(1));
            field.setFieldType(item.getText(2));
            field.setFieldArgument(item.getText(3));
            in.getFields().add(field);
        }
    }

    private void preview() {
        try {
            GetLoggingInfoMeta oneMeta = new GetLoggingInfoMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

