/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.cooplock;

import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationDao;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecordsDao;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;

public class CoopLockOperationDelete {
    private final String operationId = UUID.randomUUID().toString();
    private final Instant operationInstant = Instant.now();
    private final StorageResourceId resourceId;
    private final CoopLockRecordsDao coopLockRecordsDao;
    private final CoopLockOperationDao coopLockOperationDao;
    private Future<?> lockUpdateFuture;

    private CoopLockOperationDelete(GoogleCloudStorageImpl gcs, StorageResourceId resourceId) {
        this.resourceId = resourceId;
        this.coopLockRecordsDao = new CoopLockRecordsDao(gcs);
        this.coopLockOperationDao = new CoopLockOperationDao(gcs);
    }

    public static CoopLockOperationDelete create(GoogleCloudStorage gcs, URI path) {
        while (gcs instanceof ForwardingGoogleCloudStorage) {
            gcs = ((ForwardingGoogleCloudStorage)gcs).getDelegate();
        }
        Preconditions.checkArgument((boolean)(gcs instanceof GoogleCloudStorageImpl), (String)"gcs should be instance of %s, but was %s", GoogleCloudStorageImpl.class, gcs.getClass());
        return new CoopLockOperationDelete((GoogleCloudStorageImpl)gcs, StorageResourceId.fromUriPath(CoopLockUtils.normalizeLockedResource(path), true));
    }

    public void lock() {
        try {
            this.coopLockRecordsDao.lockPaths(this.operationId, this.operationInstant, CoopLockOperationType.DELETE, this.resourceId);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to acquire lock for %s operation", this), e);
        }
    }

    public void persistAndScheduleRenewal(List<FileInfo> itemsToDelete, List<FileInfo> bucketsToDelete) {
        try {
            this.lockUpdateFuture = this.coopLockOperationDao.persistDeleteOperation(this.operationId, this.operationInstant, this.resourceId, itemsToDelete, bucketsToDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to persist %s operation", this), e);
        }
    }

    public void unlock() {
        try {
            this.coopLockRecordsDao.unlockPaths(this.operationId, this.resourceId);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to release lock for %s operation", this), e);
        }
    }

    public void cancelRenewal() {
        this.lockUpdateFuture.cancel(false);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operationId", (Object)this.operationId).add("operationInstant", (Object)this.operationInstant).add("resourceId", (Object)this.resourceId).toString();
    }
}

