/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.Map;

public class StructUtil {
    public static Struct fromMap(Map<String, Object> config) {
        Struct.Builder b = Struct.newBuilder();
        config.forEach((k, v) -> b.putFields(k, StructUtil.toValue(v)));
        return b.build();
    }

    public static Value toValue(Object v) {
        if (v == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (v instanceof Boolean) {
            return Value.newBuilder().setBoolValue(((Boolean)v).booleanValue()).build();
        }
        if (v instanceof Number) {
            return Value.newBuilder().setNumberValue(((Number)v).doubleValue()).build();
        }
        return Value.newBuilder().setStringValue(String.valueOf(v)).build();
    }

    public static Object fromValue(Value v) {
        switch (v.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return v.getBoolValue();
            }
            case NUMBER_VALUE: {
                return StructUtil.coerceNumber(v.getNumberValue());
            }
            case STRING_VALUE: {
                return v.getStringValue();
            }
        }
        throw new UnsupportedOperationException("Unsupported engine config type: " + String.valueOf(v.getKindCase()));
    }

    public static boolean boolVal(Struct conf, String key) {
        return conf.getFieldsOrThrow(key).getBoolValue();
    }

    public static double numVal(Struct conf, String key) {
        return conf.getFieldsOrThrow(key).getNumberValue();
    }

    public static String strVal(Struct conf, String key) {
        return conf.getFieldsOrThrow(key).getStringValue();
    }

    private static Object coerceNumber(double d) {
        if (Double.isFinite(d) && d == Math.rint(d)) {
            if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                return (int)d;
            }
            if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return (long)d;
            }
        }
        return d;
    }
}

