/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config.model.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StructMapDeserializer
extends JsonDeserializer<Map<String, Struct>> {
    public Map<String, Struct> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        HashMap<String, Struct> structMap;
        block3: {
            JsonNode node;
            block2: {
                node = (JsonNode)p.getCodec().readTree(p);
                structMap = new HashMap<String, Struct>();
                if (!node.isArray()) break block2;
                for (JsonNode subNode : node) {
                    String key = subNode.asText();
                    structMap.put(key, Struct.getDefaultInstance());
                }
                break block3;
            }
            if (!node.isObject()) break block3;
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                String key = (String)field.getKey();
                JsonNode structJson = (JsonNode)field.getValue();
                String jsonString = structJson.toString();
                Struct.Builder structBuilder = Struct.newBuilder();
                JsonFormat.parser().merge(jsonString, (Message.Builder)structBuilder);
                Struct struct = structBuilder.build();
                structMap.put(key, struct);
            }
        }
        return structMap;
    }
}

