/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.hash.Funnel;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basekv.metaservice.CRDTUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.StoreKey;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVLandscapeCRDT
implements IBaseKVLandscapeCRDT {
    private final String clusterId;
    private final Logger log;
    private final ICRDTService crdtService;
    private final IORMap landscapeORMap;
    private final BehaviorSubject<Map<StoreKey, KVRangeStoreDescriptor>> landscapeSubject = BehaviorSubject.create();
    private final CompositeDisposable disposable = new CompositeDisposable();

    BaseKVLandscapeCRDT(String clusterId, ICRDTService crdtService) {
        this.clusterId = clusterId;
        this.log = MDCLogger.getLogger(BaseKVLandscapeCRDT.class, (String[])new String[]{"clusterId", clusterId});
        this.crdtService = crdtService;
        this.landscapeORMap = (IORMap)crdtService.host(CRDTUtil.toLandscapeURI(clusterId));
        this.disposable.add(this.landscapeORMap.inflation().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).map(this::buildLandscape).subscribe(arg_0 -> this.landscapeSubject.onNext(arg_0)));
        this.disposable.add(Observable.combineLatest(this.landscape(), this.aliveReplicas(), StoreDescriptorAndReplicas::new).observeOn(IBaseKVMetaService.SHARED_SCHEDULER).subscribe(this::houseKeep));
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public Observable<Long> refreshSignal() {
        return this.crdtService.refreshSignal();
    }

    @Override
    public Observable<Set<ByteString>> aliveReplicas() {
        return this.crdtService.aliveReplicas(this.landscapeORMap.id().getUri()).map(replicas -> replicas.stream().map(Replica::getId).collect(Collectors.toSet()));
    }

    @Override
    public Observable<Map<StoreKey, KVRangeStoreDescriptor>> landscape() {
        return this.landscapeSubject.distinctUntilChanged();
    }

    @Override
    public Optional<KVRangeStoreDescriptor> getStoreDescriptor(String storeId) {
        StoreKey storeKey = this.toDescriptorKey(storeId);
        return this.buildLandscape(this.landscapeORMap.getMVReg(new ByteString[]{storeKey.toByteString()}));
    }

    @Override
    public CompletableFuture<Void> setStoreDescriptor(KVRangeStoreDescriptor descriptor) {
        StoreKey storeKey = this.toDescriptorKey(descriptor.getId());
        return this.landscapeORMap.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{storeKey.toByteString()}).with(MVRegOperation.write((ByteString)descriptor.toByteString())));
    }

    @Override
    public CompletableFuture<Void> removeDescriptor(StoreKey key) {
        return this.landscapeORMap.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{key.toByteString()}).of(CausalCRDTType.mvreg));
    }

    @Override
    public CompletableFuture<Void> removeDescriptor(String storeId) {
        StoreKey storeKey = this.toDescriptorKey(storeId);
        return this.landscapeORMap.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{storeKey.toByteString()}).of(CausalCRDTType.mvreg));
    }

    @Override
    public StoreKey toDescriptorKey(String storeId) {
        return StoreKey.newBuilder().setStoreId(storeId).setReplicaId(this.landscapeORMap.id().getId()).build();
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.crdtService.stopHosting(this.landscapeORMap.id().getUri()).join();
    }

    private Map<StoreKey, KVRangeStoreDescriptor> buildLandscape(long ts) {
        HashMap<StoreKey, KVRangeStoreDescriptor> landscape = new HashMap<StoreKey, KVRangeStoreDescriptor>();
        this.landscapeORMap.keys().forEachRemaining(ormapKey -> this.buildLandscape(this.landscapeORMap.getMVReg(new ByteString[]{ormapKey.key()})).ifPresent(descriptor -> landscape.put(CRDTUtil.parseDescriptorKey(ormapKey.key()), (KVRangeStoreDescriptor)descriptor)));
        return landscape;
    }

    private Optional<KVRangeStoreDescriptor> buildLandscape(IMVReg mvReg) {
        ArrayList l = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)mvReg.read(), b -> {
            try {
                return KVRangeStoreDescriptor.parseFrom((ByteString)b);
            }
            catch (InvalidProtocolBufferException e) {
                this.log.error("Unable to parse KVRangeStoreDescriptor", (Throwable)e);
                return null;
            }
        }), Objects::nonNull));
        l.sort((a, b) -> Long.compareUnsigned(b.getHlc(), a.getHlc()));
        return Optional.ofNullable(l.isEmpty() ? null : (KVRangeStoreDescriptor)l.get(0));
    }

    private void houseKeep(StoreDescriptorAndReplicas storeDescriptorAndReplicas) {
        Map<StoreKey, KVRangeStoreDescriptor> storedDescriptors = storeDescriptorAndReplicas.descriptorMap;
        Set<ByteString> aliveReplicas = storeDescriptorAndReplicas.replicaIds;
        for (StoreKey storeKey : storedDescriptors.keySet()) {
            if (aliveReplicas.contains(storeKey.getReplicaId()) || !this.shouldClean(aliveReplicas, storeKey.getReplicaId())) continue;
            this.log.debug("store[{}] is not alive, remove its descriptor", (Object)storeKey.getStoreId());
            this.removeDescriptor(storeKey);
        }
    }

    private boolean shouldClean(Set<ByteString> aliveReplicas, ByteString failedReplicas) {
        RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodes(aliveReplicas).build();
        ByteString cleaner = (ByteString)hash.get((Object)failedReplicas);
        return cleaner != null && cleaner.equals((Object)this.landscapeORMap.id().getId());
    }

    private record StoreDescriptorAndReplicas(Map<StoreKey, KVRangeStoreDescriptor> descriptorMap, Set<ByteString> replicaIds) {
    }
}

