/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import lombok.Generated;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.TopicFilterOption;

public class RoutedMessage {
    private final String topic;
    private final Message message;
    private final ClientInfo publisher;
    private final String topicFilter;
    private final TopicFilterOption option;
    private final int bytesSize;
    private final boolean permissionGranted;
    private final boolean isDup;
    private final long hlc;
    private final long inboxPos;

    public RoutedMessage(String topic, Message message, ClientInfo publisher, String topicFilter, TopicFilterOption option, long hlc, boolean permissionGranted, boolean isDup) {
        this(topic, message, publisher, topicFilter, option, hlc, permissionGranted, isDup, 0L);
    }

    public RoutedMessage(String topic, Message message, ClientInfo publisher, String topicFilter, TopicFilterOption option, long hlc, boolean permissionGranted, boolean isDup, long inboxPos) {
        this.topic = topic;
        this.message = message;
        this.publisher = publisher;
        this.topicFilter = topicFilter;
        this.option = option;
        this.hlc = hlc;
        this.permissionGranted = permissionGranted;
        this.isDup = isDup;
        this.bytesSize = topic.length() + topicFilter.length() + message.getPayload().size();
        this.inboxPos = inboxPos;
    }

    public boolean isRetain() {
        return this.message.getIsRetained() || this.option.getRetainAsPublished() && this.message.getIsRetain();
    }

    public QoS qos() {
        return QoS.forNumber((int)Math.min(this.message.getPubQoS().getNumber(), this.option.getQos().getNumber()));
    }

    public int estBytes() {
        return this.bytesSize;
    }

    @Generated
    public String topic() {
        return this.topic;
    }

    @Generated
    public Message message() {
        return this.message;
    }

    @Generated
    public ClientInfo publisher() {
        return this.publisher;
    }

    @Generated
    public String topicFilter() {
        return this.topicFilter;
    }

    @Generated
    public TopicFilterOption option() {
        return this.option;
    }

    @Generated
    public int bytesSize() {
        return this.bytesSize;
    }

    @Generated
    public boolean permissionGranted() {
        return this.permissionGranted;
    }

    @Generated
    public boolean isDup() {
        return this.isDup;
    }

    @Generated
    public long hlc() {
        return this.hlc;
    }

    @Generated
    public long inboxPos() {
        return this.inboxPos;
    }
}

