/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.framework;

import java.io.IOException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface ServiceStateMBean {
    public static final String OBJECTNAME = "osgi.core:type=serviceState,version=1.7";
    public static final String BUNDLE_IDENTIFIER = "BundleIdentifier";
    public static final Item BUNDLE_IDENTIFIER_ITEM = new Item("BundleIdentifier", "The identifier of the bundle the service belongs to", SimpleType.LONG, new String[0]);
    public static final String OBJECT_CLASS = "objectClass";
    public static final Item OBJECT_CLASS_ITEM = new Item("objectClass", "An string array containing the interfaces under which the service has been registered", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final String IDENTIFIER = "Identifier";
    public static final Item IDENTIFIER_ITEM = new Item("Identifier", "The identifier of the service", SimpleType.LONG, new String[0]);
    public static final String PROPERTIES = "Properties";
    public static final Item PROPERTIES_ITEM = new Item("Properties", "The service properties", JmxConstants.PROPERTIES_TYPE, new String[0]);
    public static final String USING_BUNDLES = "UsingBundles";
    public static final Item USING_BUNDLES_ITEM = new Item("UsingBundles", "The bundles using the service", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final CompositeType SERVICE_TYPE = Item.compositeType("SERVICE", "This type encapsulates an OSGi service", BUNDLE_IDENTIFIER_ITEM, IDENTIFIER_ITEM, OBJECT_CLASS_ITEM, PROPERTIES_ITEM, USING_BUNDLES_ITEM);
    public static final TabularType SERVICES_TYPE = Item.tabularType("SERVICES", "The table of all services", SERVICE_TYPE, "Identifier");
    public static final String BUNDLE_LOCATION = "BundleLocation";
    public static final Item BUNDLE_LOCATION_ITEM = new Item("BundleLocation", "The location of the bundle", SimpleType.STRING, new String[0]);
    public static final String BUNDLE_SYMBOLIC_NAME = "BundleSymbolicName";
    public static final Item BUNDLE_SYMBOLIC_NAME_ITEM = new Item("BundleSymbolicName", "The symbolic name of the bundle", SimpleType.STRING, new String[0]);
    public static final String EVENT = "ServiceEvent";
    public static final Item EVENT_ITEM = new Item("ServiceEvent", "The eventType of the event: {REGISTERED=1, MODIFIED=2 UNREGISTERING=3}", SimpleType.INTEGER, new String[0]);
    public static final CompositeType SERVICE_EVENT_TYPE = Item.compositeType("SERVICE_EVENT", "This type encapsulates OSGi service events", IDENTIFIER_ITEM, OBJECT_CLASS_ITEM, BUNDLE_IDENTIFIER_ITEM, BUNDLE_LOCATION_ITEM, BUNDLE_SYMBOLIC_NAME_ITEM, EVENT_ITEM);

    public String[] getObjectClass(long var1) throws IOException;

    public long getBundleIdentifier(long var1) throws IOException;

    public CompositeData getService(long var1) throws IOException;

    public TabularData getProperties(long var1) throws IOException;

    public CompositeData getProperty(long var1, String var3) throws IOException;

    public long[] getServiceIds() throws IOException;

    public TabularData listServices() throws IOException;

    public TabularData listServices(String var1, String var2) throws IOException;

    public TabularData listServices(String var1, String var2, String ... var3) throws IOException;

    public long[] getUsingBundles(long var1) throws IOException;
}

