/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.SignatureException;
import org.apache.sshd.common.util.security.eddsa.generic.GenericSignatureEd25519;

public class SignatureEd25519
extends GenericSignatureEd25519 {
    private static final int[] ED25519_ORDER = new int[]{237, 211, 245, 92, 26, 99, 18, 88, 214, 156, 247, 162, 222, 249, 222, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16};

    public SignatureEd25519() {
        super("NONEwithEdDSA");
    }

    @Override
    protected boolean doVerify(byte[] data) throws SignatureException {
        if (data.length != 64 || !SignatureEd25519.isValidFactor(data)) {
            return false;
        }
        return super.doVerify(data);
    }

    private static boolean isValidFactor(byte[] sig) {
        for (int i = 31; i >= 0; --i) {
            int y = (sig[i + 32] & 0xFF) - ED25519_ORDER[i];
            if (y == 0) continue;
            return y < 0;
        }
        return false;
    }
}

