/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis.consumer;

import java.util.Objects;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;

public class OffsetOption {
    public static final long POLICY_LAST_VALUE = 0L;
    public static final long POLICY_MIN_VALUE = 1L;
    public static final long POLICY_MAX_VALUE = 2L;
    public static final OffsetOption LAST_OFFSET = new OffsetOption(Type.POLICY, 0L);
    public static final OffsetOption MIN_OFFSET = new OffsetOption(Type.POLICY, 1L);
    public static final OffsetOption MAX_OFFSET = new OffsetOption(Type.POLICY, 2L);
    private final Type type;
    private final long value;

    private OffsetOption(Type type, long value) {
        this.type = type;
        this.value = value;
    }

    public static OffsetOption ofOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must be greater than or equal to 0");
        }
        return new OffsetOption(Type.OFFSET, offset);
    }

    public static OffsetOption ofTailN(long tailN) {
        if (tailN < 0L) {
            throw new IllegalArgumentException("tailN must be greater than or equal to 0");
        }
        return new OffsetOption(Type.TAIL_N, tailN);
    }

    public static OffsetOption ofTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp must be greater than or equal to 0");
        }
        return new OffsetOption(Type.TIMESTAMP, timestamp);
    }

    public Type getType() {
        return this.type;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetOption option = (OffsetOption)o;
        return this.value == option.value && this.type == option.type;
    }

    public int hashCode() {
        int result = Objects.hashCode((Object)this.type);
        result = 31 * result + Long.hashCode(this.value);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("value", this.value).toString();
    }

    public static enum Type {
        POLICY,
        OFFSET,
        TAIL_N,
        TIMESTAMP;

    }
}

