# Podling Maturity Assessment for ShardingSphere

## Overview

This is an assessment of the ShardingSphere podling’s maturity, meant to help inform the decision (of the mentors, community, Incubator PMC and ASF Board of Directors) to graduate it as a top-level Apache project.

It is based on the ASF project maturity model at https://community.apache.org/apache-way/apache-project-maturity-model.html

## Status of this document

All open items are updated with the latest status.

## Maturity model assessment

Mentors and community members are encouraged to contribute to this page and comment on it, the following table summarizes project’s self-assessment against the Apache Maturity Model.

**CODE**

| **ID**   | **Description**                                                                                                                                                                                                                                                                 | **Status**                                                                                                                                                                                                                                                                                   |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **CD10** | The project produces Open Source software, for distribution to the public at no charge.                                                                                                                                                                                         | **YES.** The project source code is licensed under the `Apache License 2.0`.                                                                                                                                                                                                                 |
| **CD20** | The project's code is easily discoverable and publicly accessible.                                                                                                                                                                                                              | **YES.** The [website](https://shardingsphere.apache.org/) includes `SCM` link which can access GitHub directly.                                                                                                                                                                             |
| **CD30** | The code can be built in a reproducible way using widely available standard tools.                                                                                                                                                                                              | **YES.** The build uses Apache Maven and Jenkins as the continuous integration tools, user can find `How to Build` in the [GitHub's README.md](https://github.com/apache/incubator-shardingsphere/blob/dev/README.md) for more information.                                                  |
| **CD40** | The full history of the project's code is available via a source code control system, in a way that allows any released version to be recreated.                                                                                                                                | **YES.** The project uses git to manage source code, demo code, documentation and website, all releases are tagged.                                                                                                                                                                          |
| **CD50** | The provenance of each line of code is established via the source code control system, in a reliable way based on strong authentication of the committer. When third-party contributions are committed, commit messages provide reliable information about the code provenance. | **YES.** The project uses GitHub which managed by Apache Infra, it ensuring provenance of each line of code to a committer. The third-party contributions are accepted in accordance with the [contributor guide](https://shardingsphere.apache.org/community/en/involved/contribute/) only. |

**Licenses and Copyright**

| **ID**   | **Description**                                                                                                                                                                              | **Status**                                                                                                                                                                                                            |
|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **LC10** | The code is released under the Apache License, version 2.0.                                                                                                                                  | **YES.** The [LICENSE file](https://github.com/apache/shardingsphere/blob/master/LICENSE) is in GitHub repository.                                                                                                    |
| **LC20** | Libraries that are mandatory dependencies of the project's code do not create more restrictions than the Apache License does.                                                                | **YES.** The [list of dependencies](https://github.com/apache/shardingsphere/tree/master/distribution/proxy/src/main/release-docs/licenses) for binary release has been reviewed to contain compatible licenses only. |
| **LC30** | The libraries mentioned in LC20 are available as Open Source software.                                                                                                                       | **YES.** See LC20's dependencies list.                                                                                                                                                                                |
| **LC40** | Committers are bound by an Individual Contributor Agreement (the "Apache iCLA") that defines which code they are allowed to commit and how they need to identify code that is not their own. | **YES.** All committers have iCLAs on file before they have an apache account.                                                                                                                                        |
| **LC50** | The copyright ownership of everything that the project produces is clearly defined and documented.                                                                                           | **YES.** All files in the source code have appropriate headers and checked by `Apache rat plugin` when build.                                                                                                         |

**Releases**

| **ID**   | **Description**                                                                                                                                                                        | **Status**                                                                                                                                                                                                                                                                                                                 |
|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **RE10** | Releases consist of source code, distributed using standard and open archive formats that are expected to stay readable in the long term.                                              | **YES.** Source release is distributed via [dist.apache.org](https://dist.apache.org/repos/dist/release/incubator/shardingsphere/) and linked from [download page](https://shardingsphere.apache.org/document/current/en/downloads/).                                                                                      |
| **RE20** | Releases are approved by the project's PMC (see CS10), in order to make them an act of the Foundation.                                                                                 | **YES.** All releases have been voted by ShardingSphere community and incubator, which have least 3 (P)PMC votes.                                                                                                                                                                                                          |
| **RE30** | Releases are signed and/or distributed along with digests that can be reliably used to validate the downloaded archives.                                                               | **YES.** All releases are signed, and the [KEYS file](https://dist.apache.org/repos/dist/release/incubator/shardingsphere/KEYS) is provided on dist.apache.org.                                                                                                                                                            |
| **RE40** | Convenience binaries can be distributed alongside source code but they are not Apache Releases -- they are just a convenience provided with no guarantee.                              | **YES.** Convenience binaries are distributed via [Maven Central Repository](https://mvnrepository.com/artifact/org.apache.shardingsphere), [DockerHub](https://hub.docker.com/r/apache/sharding-proxy/tags) and [dist.apache.org](https://dist.apache.org/repos/dist/release/incubator/shardingsphere/) at the same time. |
| **RE50** | The release process is documented and repeatable to the extent that someone new to the project is able to independently generate the complete set of artifacts required for a release. | **YES.** [Release guide](https://shardingsphere.apache.org/community/en/involved/release/) is available. The releases of the project have been performed by 3 different release managers.                                                                                                                                  |

**Quality**

| **ID**   | **Description**                                                                                                                                                                               | **Status**                                                                                                                                             |
|----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------|
| **QU10** | The project is open and honest about the quality of its code. Various levels of quality and maturity for various modules are natural and acceptable as long as they are clearly communicated. | **YES.** All [issues](https://github.com/apache/incubator-shardingsphere/issues) record in ShardingSphere's GitHub repository.                         |
| **QU20** | The project puts a very high priority on producing secure software.                                                                                                                           | **YES.** Security issues are treated with the highest priority.                                                                                        |
| **QU30** | The project provides a well-documented, secure and private channel to report security issues, along with a documented way of responding to them.                                              | **YES.** Website provides a [security page](https://shardingsphere.apache.org/community/en/security/)                                                  |
| **QU40** | The project puts a high priority on backwards compatibility and aims to document any incompatible changes and provide tools and documentation to help users transition to new features.       | **YES.** Each release note contains all related issues and pull requests in the milestone, and extract mainly updates and API changes from milestones. |
| **QU50** | The project strives to respond to documented bug reports in a timely manner.                                                                                                                  | **YES.** The project has resolved 2000+ issues and 1200+ pull requests during 3 years. The response times on are pretty good.                          |

**Community**

| **ID**   | **Description**                                                                                                                                                                          | **Status**                                                                                                                                                                                                                                 |
|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **CO10** | The project has a well-known homepage that points to all the information required to operate according to this maturity model.                                                           | **YES.** The [website](https://shardingsphere.apache.org/) describes of the project with download, user manual, technical details, how to contribute and team introduce.                                                                   |
| **CO20** | The community welcomes contributions from anyone who acts in good faith and in a respectful manner and adds value to the project.                                                        | **YES.** There is [contributor guide](https://shardingsphere.apache.org/community/en/involved/contribute/) and the current committers are really welcome contributions.                                                                    |
| **CO30** | Contributions include not only source code, but also documentation, constructive bug reports, constructive discussions, marketing and generally anything that adds value to the project. | **YES.** The contribution guide refers to non source code contribution, like [documentation](https://shardingsphere.apache.org/community/en/involved/contribute/document/). The community has elected some non-coding committers.          |
| **CO40** | The community strives to be meritocratic and over time aims to give more rights and responsibilities to contributors who add value to the project.                                       | **YES.** The community has elected 2 new PPMC members and 4 new committers during incubation, based on meritocracy.                                                                                                                        |
| **CO50** | The way in which contributors can be granted more rights such as commit access or decision power is clearly documented and is the same for all contributors.                             | **YES.** The criteria is documented in the [committer guide](https://shardingsphere.apache.org/community/en/involved/committer/).                                                                                                          |
| **CO60** | The community operates based on consensus of its members (see CS10) who have decision power. Dictators, benevolent or not, are not welcome in Apache projects.                           | **YES.** The project works to build consensus. All votes have been unanimous so far.                                                                                                                                                       |
| **CO70** | The project strives to answer user questions in a timely manner.                                                                                                                         | **YES.** The project typically provides detailed answers to user questions within a few days via [dev@ mailing list](mailto:dev@shardingsphere.apache.org) and [GitHub issues](https://github.com/apache/incubator-shardingsphere/issues). |

**Consensus**

| **ID**   | **Description**                                                                                                                                                                                                              | **Status**                                                                                                                                                                                           |
|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **CS10** | The project maintains a public list of its contributors who have decision power -- the project's PMC (Project Management Committee) consists of those contributors.                                                          | **YES.** The [team page](https://shardingsphere.apache.org/community/en/team/) list all of PPMC members and committers.                                                                              |
| **CS20** | Decisions are made by consensus among PMC members 9 and are documented on the project's main communications channel. Community opinions are taken into account but the PMC has the final word if needed.                     | **YES.** The project has been making important decisions on the mailing lists.                                                                                                                       |
| **CS30** | Documented voting rules are used to build consensus when discussion is not sufficient.                                                                                                                                       | **YES.** The project uses the standard ASF voting rules.                                                                                                                                             |
| **CS40** | In Apache projects, vetoes are only valid for code commits and are justified by a technical explanation, as per the Apache voting rules defined in CS30.                                                                     | **YES.** The project has not used a veto at any point during incubating.                                                                                                                             |
| **CS50** | All "important" discussions happen asynchronously in written form on the project's main communications channel. Offline, face-to-face or private discussions 11 that affect the project are also documented on that channel. | **YES.** The project has been making important decisions on the project mailing lists. Minor decisions may occasionally happen during code reviews, which are also asynchronous and in written form. |

**Independence**

| **ID**   | **Description**                                                                                | **Status**                                                                                                                                                                                                                                                                         |
|----------|------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **IN10** | The project is independent from any corporate or organizational influence.                     | **YES.** The project team gathers people from different companies (JD.com, dangdang.com, CHINA TELECOM Bestpay, DAOCloud). No company or organization has significantly more influence than any other. We can note a growth of the contributions coming from different committers. |
| **IN20** | Contributors act as themselves as opposed to representatives of a corporation or organization. | **YES.** The contributors act on their own initiative without representing a corporation or organization.                                                                                                                                                                          |

Mentors, PPMCs and committers please discuss and modify on [wiki](https://cwiki.apache.org/confluence/display/SHARDINGSPHERE/Podling+Maturity+Assessment+for+ShardingSphere).
