/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.database.protocol.postgresql.constant;

import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.junit.jupiter.api.Test;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;

class PostgreSQLValueFormatTest {
    
    @Test
    void assertValueOfText() {
        assertThat(PostgreSQLValueFormat.valueOf(0), is(PostgreSQLValueFormat.TEXT));
    }
    
    @Test
    void assertValueOfBinary() {
        assertThat(PostgreSQLValueFormat.valueOf(1), is(PostgreSQLValueFormat.BINARY));
    }
    
    @Test
    void assertValueOfThrowsOnUnknown() {
        UnsupportedSQLOperationException ex = assertThrows(UnsupportedSQLOperationException.class, () -> PostgreSQLValueFormat.valueOf(2));
        assertThat(ex.getMessage(), is("Unsupported SQL operation: Unsupported PostgreSQL format code `2`."));
    }
}
