/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.mode.manager.cluster.exclusive;

import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.core.lock.DistributedLockHolder;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;
import org.apache.shardingsphere.test.infra.framework.extension.mock.AutoMockExtension;
import org.apache.shardingsphere.test.infra.framework.extension.mock.StaticMockSettings;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@ExtendWith(AutoMockExtension.class)
@StaticMockSettings(DistributedLockHolder.class)
class ClusterExclusiveOperatorContextTest {
    
    @Mock
    private ClusterPersistRepository repository;
    
    @Mock
    private DistributedLock distributedLock;
    
    @Test
    void assertStartTryLock() {
        when(DistributedLockHolder.getDistributedLock("op", repository)).thenReturn(distributedLock);
        when(distributedLock.tryLock(50L)).thenReturn(true);
        assertTrue(new ClusterExclusiveOperatorContext(repository).start("op", 50L));
        verify(distributedLock).tryLock(50L);
    }
    
    @Test
    void assertStopUnlock() {
        when(DistributedLockHolder.getDistributedLock("op", repository)).thenReturn(distributedLock);
        new ClusterExclusiveOperatorContext(repository).stop("op");
        verify(distributedLock).unlock();
    }
}
