/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column;

import lombok.Getter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ColumnInResultSetSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;

import java.util.Optional;

/**
 * Describe statement for MySQL.
 */
@Getter
public final class MySQLDescribeStatement extends DALStatement {
    
    private final SimpleTableSegment table;
    
    private final ColumnSegment columnWildcard;
    
    private SQLStatementAttributes attributes;
    
    private final boolean showAll;
    
    public MySQLDescribeStatement(final DatabaseType databaseType, final SimpleTableSegment table, final ColumnSegment columnWildcard) {
        this(databaseType, table, columnWildcard, false);
    }
    
    public MySQLDescribeStatement(final DatabaseType databaseType, final SimpleTableSegment table, final ColumnSegment columnWildcard, final boolean showAll) {
        super(databaseType);
        this.table = table;
        this.columnWildcard = columnWildcard;
        this.showAll = showAll;
    }
    
    /**
     * Get column wildcard.
     *
     * @return column wildcard
     */
    public Optional<ColumnSegment> getColumnWildcard() {
        return Optional.ofNullable(columnWildcard);
    }
    
    @Override
    public void buildAttributes() {
        attributes = new SQLStatementAttributes(new ColumnInResultSetSQLStatementAttribute(1), new TableSQLStatementAttribute(table));
    }
}
