/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PipelineMonitor {
    private final List<Record> items = new LinkedList<Record>();
    private volatile boolean closed = false;
    private Exception closedOn;
    private final PipelineMonitor parent;

    public PipelineMonitor() {
        this.parent = null;
        this.action("COMPLETE", Type.ENQUEUE, null);
    }

    public PipelineMonitor(PipelineMonitor parent) {
        this.parent = parent;
    }

    public final synchronized PipelineMonitor action(String name, Type type, Object target) {
        PipelineMonitor monitor = this.checkClosed();
        monitor.items.add(new Record(name, System.nanoTime(), type, target));
        return monitor;
    }

    public synchronized PipelineMonitor close() {
        if (this.closed) {
            throw new IllegalStateException("already closed", this.closedOn);
        }
        this.action("COMPLETE", Type.END, null);
        this.closed = true;
        this.closedOn = new Exception();
        return this;
    }

    private PipelineMonitor checkClosed() {
        if (this.closed) {
            PipelineMonitor clone = new PipelineMonitor(this);
            return clone;
        }
        return this;
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        if (!this.isClosed()) {
            throw new IllegalStateException("not closed");
        }
        StringBuilder builder = new StringBuilder("\n" + this.parent + "\n");
        this.items.forEach(r -> builder.append("\t" + r + "\n"));
        builder.append("time:" + TimeUnit.NANOSECONDS.toMicros(this.items.get((int)(this.items.size() - 1)).time - this.items.get((int)0).time));
        builder.append('\n');
        Set names = this.items.stream().map(i -> i.name).collect(Collectors.toSet());
        builder.append(names.toString());
        builder.append('\n');
        for (String name : names) {
            builder.append(name);
            builder.append('\n');
            this.items.stream().filter(i -> i.name.equals(name)).reduce((l, r) -> {
                if (l.type != Type.END) {
                    builder.append("\t" + (Object)((Object)l.type) + "->" + (Object)((Object)r.type) + " time:" + (r.time - l.time) + " ");
                }
                return r;
            });
            builder.append('\n');
        }
        return builder.toString();
    }

    public class Record {
        public final String name;
        public final String thread;
        public final long time;
        public final Type type;
        public final Object record;

        public Record(String name, long time, Type type, Object record) {
            this.name = name;
            this.time = time;
            this.type = type;
            this.record = record;
            this.thread = Thread.currentThread().getName();
        }

        public String toString() {
            return "Record{name=" + this.name + ", thread=" + this.thread + ", time=" + this.time + ", type=" + (Object)((Object)this.type) + '}';
        }
    }

    public static enum Type {
        ENQUEUE,
        RUN,
        END;

    }
}

