/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Tuple3<T1, T2, T3> {
    public final T1 t1;
    public final T2 t2;
    public final T3 t3;

    private Tuple3(T1 t1, T2 t2, T3 t3) {
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
    }

    public T1 getT1() {
        return this.t1;
    }

    public T2 getT2() {
        return this.t2;
    }

    public T3 getT3() {
        return this.t3;
    }

    public Optional<T1> findT1() {
        return Optional.ofNullable(this.t1);
    }

    public Optional<T2> findT2() {
        return Optional.ofNullable(this.t2);
    }

    public Optional<T3> findT3() {
        return Optional.ofNullable(this.t3);
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> tuple3(T1 t1, T2 t2, T3 t3) {
        return new Tuple3<T1, T2, T3>(t1, t2, t3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple3 tuple3 = (Tuple3)o;
        return Objects.deepEquals(this.t1, tuple3.t1) && Objects.deepEquals(this.t2, tuple3.t2) && Objects.deepEquals(this.t3, tuple3.t3);
    }

    public int hashCode() {
        return Objects.hash(this.t1, this.t2, this.t3);
    }

    public String toString() {
        return "(" + this.t1 + ", " + this.t2 + ", " + this.t3 + ")";
    }

    public Tuple3<T1, T2, T3> ifAllPresent(Consumer<Tuple3<T1, T2, T3>> c) {
        if (this.t1 != null && this.t2 != null && this.t3 != null) {
            c.accept(this);
        }
        return this;
    }
}

