/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class TemplateModal
extends AbstractModalPanel<MailTemplateTO> {
    private static final long serialVersionUID = 2053048734388383021L;
    private final MailTemplateTO templateTO;
    private final NotificationRestClient restClient;

    public TemplateModal(BaseModal<MailTemplateTO> modal, NotificationRestClient restClient, MailTemplateTO templateTO, PageReference pageRef) {
        super(modal, pageRef);
        this.restClient = restClient;
        this.templateTO = templateTO;
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)templateTO, "key"), false);
        key.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{key.setRenderBodyOnly(true)});
    }

    @Override
    public MailTemplateTO getItem() {
        return this.templateTO;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.restClient.createTemplate(this.templateTO);
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (SyncopeClientException e) {
            LOG.error("While creating template for {}", (Object)this.templateTO.getKey(), (Object)e);
            SyncopeConsoleSession.get().onException((Exception)((Object)e));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

