/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextFactory;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.runtime.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected ClassLoader classLoader;
    protected boolean useClassForNameClassLoading;
    protected Clock clock;
    protected ObjectMapper objectMapper;
    protected Map<String, AbstractEngineConfiguration> engineConfigurations = new HashMap<String, AbstractEngineConfiguration>();
    protected String engineCfgKey;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ClassLoader classLoader, boolean useClassForNameClassLoading, Clock clock, ObjectMapper objectMapper) {
        this.commandContextFactory = commandContextFactory;
        this.classLoader = classLoader;
        this.useClassForNameClassLoading = useClassForNameClassLoading;
        this.clock = clock;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command, CommandExecutor commandExecutor) {
        CommandContext commandContext = Context.getCommandContext();
        boolean contextReused = false;
        boolean originalContextReusedState = false;
        if (!config.isContextReusePossible() || commandContext == null || commandContext.getException() != null) {
            commandContext = this.commandContextFactory.createCommandContext(command);
            commandContext.setEngineConfigurations(this.engineConfigurations);
            commandContext.setCommandExecutor(commandExecutor);
            commandContext.setClassLoader(this.classLoader);
            commandContext.setUseClassForNameClassLoading(this.useClassForNameClassLoading);
            commandContext.setClock(this.clock);
            commandContext.setObjectMapper(this.objectMapper);
        } else {
            LOGGER.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
            originalContextReusedState = commandContext.isReused();
            commandContext.setReused(true);
        }
        try {
            commandContext.pushEngineCfgToStack(this.engineCfgKey);
            Context.setCommandContext(commandContext);
            T t = this.next.execute(config, command, commandExecutor);
            return t;
        }
        catch (Throwable e) {
            commandContext.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    commandContext.close();
                }
                commandContext.setReused(originalContextReusedState);
            }
            finally {
                commandContext.popEngineCfgStack();
                Context.removeCommandContext();
            }
        }
        if (contextReused && commandContext.getException() != null) {
            Throwable exception = commandContext.getException();
            commandContext.resetException();
            if (exception instanceof FlowableException) {
                throw (FlowableException)exception;
            }
            throw new FlowableException("Exception during command execution", exception);
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public Map<String, AbstractEngineConfiguration> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfigurations(Map<String, AbstractEngineConfiguration> engineConfigurations) {
        this.engineConfigurations = engineConfigurations;
    }

    public String getEngineCfgKey() {
        return this.engineCfgKey;
    }

    public void setEngineCfgKey(String engineCfgKey) {
        this.engineCfgKey = engineCfgKey;
    }
}

