/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.AnyTypeCheck;

public class AnyTypeValidator
extends AbstractValidator<AnyTypeCheck, AnyType> {
    public boolean isValid(AnyType anyType, ConstraintValidatorContext context) {
        boolean nameKindMatch;
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (this.isHtml(anyType.getKey())) {
            context.buildConstraintViolationWithTemplate(AnyTypeValidator.getTemplate(EntityViolationType.InvalidKey, anyType.getKey())).addPropertyNode("key").addConstraintViolation();
            isValid = false;
        }
        switch (anyType.getKind()) {
            case USER: {
                nameKindMatch = AnyTypeKind.USER.name().equalsIgnoreCase(anyType.getKey());
                break;
            }
            case GROUP: {
                nameKindMatch = AnyTypeKind.GROUP.name().equalsIgnoreCase(anyType.getKey());
                break;
            }
            default: {
                boolean bl = nameKindMatch = !AnyTypeKind.USER.name().equalsIgnoreCase(anyType.getKey()) && !AnyTypeKind.GROUP.name().equalsIgnoreCase(anyType.getKey()) && !"REALM".equalsIgnoreCase(anyType.getKey());
            }
        }
        if (!nameKindMatch) {
            context.buildConstraintViolationWithTemplate(AnyTypeValidator.getTemplate(EntityViolationType.InvalidAnyType, "Name / kind mismatch")).addPropertyNode("name").addConstraintViolation();
        }
        return isValid && nameKindMatch;
    }
}

