/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class ColorBehavior
extends BootstrapBaseBehavior {
    private final Color color;

    public ColorBehavior(Color color) {
        this.color = color;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, this.color.cssClassName());
    }

    public static ColorBehavior primary() {
        return new ColorBehavior(Color.Primary);
    }

    public static ColorBehavior secondary() {
        return new ColorBehavior(Color.Secondary);
    }

    public static ColorBehavior success() {
        return new ColorBehavior(Color.Success);
    }

    public static ColorBehavior danger() {
        return new ColorBehavior(Color.Danger);
    }

    public static ColorBehavior warning() {
        return new ColorBehavior(Color.Warning);
    }

    public static ColorBehavior info() {
        return new ColorBehavior(Color.Info);
    }

    public static ColorBehavior light() {
        return new ColorBehavior(Color.Light);
    }

    public static ColorBehavior dark() {
        return new ColorBehavior(Color.Dark);
    }

    public static ColorBehavior body() {
        return new ColorBehavior(Color.Body);
    }

    public static ColorBehavior muted() {
        return new ColorBehavior(Color.Muted);
    }

    public static ColorBehavior white() {
        return new ColorBehavior(Color.White);
    }

    public static ColorBehavior black50() {
        return new ColorBehavior(Color.Black50);
    }

    public static ColorBehavior white50() {
        return new ColorBehavior(Color.White50);
    }

    public static enum Color {
        Primary("primary"),
        Secondary("secondary"),
        Success("success"),
        Danger("danger"),
        Warning("warning"),
        Info("info"),
        Light("light"),
        Dark("dark"),
        Body("body"),
        Muted("muted"),
        White("white"),
        Black("black"),
        Black50("black-50"),
        White50("white-50");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return String.format("text-%s", this.value);
        }
    }
}

