/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.handlers;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.OutputStream;

public class MultipartHandler
implements DataContentHandler {
    private final ActivationDataFlavor flavour = new ActivationDataFlavor(MimeMultipart.class, "multipart/mixed", "Multipart MIME");

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return new ActivationDataFlavor[]{this.flavour};
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        return this.flavour.equals(df) ? this.getContent(ds) : null;
    }

    public Object getContent(DataSource ds) throws IOException {
        try {
            return new MimeMultipart(ds);
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj instanceof MimeMultipart) {
            MimeMultipart mp = (MimeMultipart)obj;
            try {
                mp.writeTo(os);
            }
            catch (MessagingException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
    }
}

