/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.ext.reqattr.RequestedAttributes;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class SAMLAddAttributeConsumingServiceHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLAddAttributeConsumingServiceHandler.class);
    @Nonnull
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class));
    @Nonnull
    private Function<MessageContext, AuthnRequest> authnRequestLookupStrategy = new AuthnRequestLookup();
    @Nullable
    private Integer index;
    @Nullable
    private Collection<RequestedAttribute> requestedAttributes;

    public void setMetadataContextLookupStrategy(@Nonnull Function<MessageContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setIndexLookupStrategy(@Nullable Function<MessageContext, AuthnRequest> strategy) {
        this.authnRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        AuthnRequest authn = this.authnRequestLookupStrategy.apply(messageContext);
        if (authn != null) {
            this.index = authn.getAttributeConsumingServiceIndex();
            this.requestedAttributes = this.getRequestedAttributes(messageContext, authn);
            if (this.index != null && this.requestedAttributes != null && !this.requestedAttributes.isEmpty()) {
                this.log.info("{} AuthnRequest from {} contained AttributeConsumingServiceIndex and RequestedAttributes; ignoring AttributeConsumingServiceIndex.", (Object)this.getLogPrefix(), (Object)authn.getProviderName());
                this.index = null;
            }
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SPSSODescriptor ssoDescriptor;
        SAMLMetadataContext metadataContext = this.metadataContextLookupStrategy.apply(messageContext);
        if (metadataContext == null) {
            this.log.debug("{} No metadata context found, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (metadataContext.getRoleDescriptor() instanceof SPSSODescriptor) {
            ssoDescriptor = (SPSSODescriptor)metadataContext.getRoleDescriptor();
        } else {
            if (this.index != null) {
                this.log.info("{} No metadata available, ignoring AttributeConsumingServiceIndex", (Object)this.getLogPrefix());
                return;
            }
            ssoDescriptor = null;
        }
        AttributeConsumingService acs = null;
        if (null != this.index) {
            this.log.debug("{} Request specified AttributeConsumingService index {}", (Object)this.getLogPrefix(), (Object)this.index);
            assert (ssoDescriptor != null);
            for (AttributeConsumingService acsEntry : ssoDescriptor.getAttributeConsumingServices()) {
                assert (this.index != null);
                if (!this.index.equals(acsEntry.getIndex())) continue;
                acs = acsEntry;
                break;
            }
        }
        if (null == acs) {
            if (this.requestedAttributes != null && !this.requestedAttributes.isEmpty()) {
                this.log.debug("{} Creating AttributeConsumingService around RequestedAttributes", (Object)this.getLogPrefix());
                acs = this.attributeConsumingServiceFromRequestedAttributes();
            } else if (ssoDescriptor != null) {
                this.log.debug("{} Selecting default AttributeConsumingService, if any", (Object)this.getLogPrefix());
                acs = ssoDescriptor.getDefaultAttributeConsumingService();
            }
        }
        if (null != acs) {
            this.log.debug("{} Selected AttributeConsumingService with index {}", (Object)this.getLogPrefix(), (Object)acs.getIndex());
            ((AttributeConsumingServiceContext)metadataContext.ensureSubcontext(AttributeConsumingServiceContext.class)).setAttributeConsumingService(acs);
        } else {
            this.log.debug("{} No AttributeConsumingService selected", (Object)this.getLogPrefix());
        }
    }

    @Nonnull
    private AttributeConsumingService attributeConsumingServiceFromRequestedAttributes() throws MessageHandlerException {
        AttributeConsumingService newAcs = (AttributeConsumingService)XMLObjectSupport.buildXMLObject((QName)AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        assert (this.requestedAttributes != null);
        for (RequestedAttribute attribute : this.requestedAttributes) {
            assert (attribute != null);
            try {
                newAcs.getRequestedAttributes().add((RequestedAttribute)XMLObjectSupport.cloneXMLObject((XMLObject)attribute, (XMLObjectSupport.CloneOutputOption)XMLObjectSupport.CloneOutputOption.DropDOM));
            }
            catch (MarshallingException | UnmarshallingException e) {
                this.log.warn("{} Error cloning requested Attributes: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                throw new MessageHandlerException((Exception)e);
            }
        }
        return newAcs;
    }

    @Nullable
    protected Collection<RequestedAttribute> getRequestedAttributes(@Nonnull MessageContext messageContext, @Nonnull AuthnRequest authn) {
        Extensions extensions = authn.getExtensions();
        if (extensions == null) {
            return null;
        }
        List exts = extensions.getUnknownXMLObjects(RequestedAttributes.DEFAULT_ELEMENT_NAME);
        if (exts == null || exts.isEmpty()) {
            return null;
        }
        return ((RequestedAttributes)exts.get(0)).getRequestedAttributes();
    }

    private class AuthnRequestLookup
    implements Function<MessageContext, AuthnRequest> {
        private AuthnRequestLookup() {
        }

        @Override
        @Nullable
        public AuthnRequest apply(@Nullable MessageContext input) {
            Object message;
            if (input != null && (message = input.getMessage()) instanceof AuthnRequest) {
                return (AuthnRequest)message;
            }
            return null;
        }
    }
}

