/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.util.lang.ClassUtils;

public class NoInjectionAnnotationInjectionProvider
extends InjectionProvider {
    private static volatile WeakHashMap<ClassLoader, Map<Class, Method[]>> declaredMethodBeans = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, Method[]> getDeclaredMethodBeansMap() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        Map<Class, Method[]> metadata = declaredMethodBeans.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, Map<Class, Method[]>> weakHashMap = declaredMethodBeans;
            synchronized (weakHashMap) {
                metadata = NoInjectionAnnotationInjectionProvider.createDeclaredMethodBeansMap(cl, metadata);
            }
        }
        return metadata;
    }

    private static Map<Class, Method[]> createDeclaredMethodBeansMap(ClassLoader cl, Map<Class, Method[]> metadata) {
        metadata = declaredMethodBeans.get(cl);
        if (metadata == null) {
            metadata = new HashMap<Class, Method[]>();
            declaredMethodBeans.put(cl, metadata);
        }
        return metadata;
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException {
        try {
            this.processAnnotations(instance);
        }
        catch (IllegalAccessException | InvocationTargetException | NamingException ex) {
            throw new InjectionProviderException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method[] getDeclaredMethods(Class clazz) {
        Map<Class, Method[]> declaredMethodBeansMap = NoInjectionAnnotationInjectionProvider.getDeclaredMethodBeansMap();
        Method[] methods = declaredMethodBeansMap.get(clazz);
        if (methods == null) {
            methods = clazz.getDeclaredMethods();
            Map<Class, Method[]> map = declaredMethodBeansMap;
            synchronized (map) {
                declaredMethodBeansMap.put(clazz, methods);
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException {
        Class<?> clazz = instance.getClass();
        Method[] methods = this.getDeclaredMethods(clazz);
        if (methods == null) {
            Map<Class, Method[]> declaredMethodBeansMap;
            methods = clazz.getDeclaredMethods();
            Map<Class, Method[]> map = declaredMethodBeansMap = NoInjectionAnnotationInjectionProvider.getDeclaredMethodBeansMap();
            synchronized (map) {
                declaredMethodBeansMap.put(clazz, methods);
            }
        }
        Method postConstruct = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct annotation");
            }
            postConstruct = method;
        }
        try {
            this.invokeAnnotatedMethod(postConstruct, instance);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new InjectionProviderException(ex);
        }
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException {
        Class<?> clazz = instance.getClass();
        Method[] methods = this.getDeclaredMethods(clazz);
        Method preDestroy = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PreDestroy annotation");
            }
            preDestroy = method;
        }
        try {
            this.invokeAnnotatedMethod(preDestroy, instance);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new InjectionProviderException(ex);
        }
    }

    private void invokeAnnotatedMethod(Method method, Object instance) throws IllegalAccessException, InvocationTargetException {
        if (method != null) {
            boolean accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
            method.setAccessible(accessibility);
        }
    }

    protected void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
    }
}

