/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.opensaml.saml.metadata.criteria.entity.DetectDuplicateEntityIDsCriterion;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.DetectDuplicateEntityIDs;
import org.opensaml.saml.metadata.resolver.DynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class ChainingMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver,
RefreshableMetadataResolver,
ClearableMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataResolver.class);
    @Nullable
    @NotEmpty
    private String resolverType;
    @Nonnull
    private List<MetadataResolver> resolvers = CollectionSupport.emptyList();
    @Nonnull
    private DetectDuplicateEntityIDs detectDuplicateEntityIDs = DetectDuplicateEntityIDs.Off;
    @Nullable
    private Predicate<ProfileRequestContext> activationCondition;

    @Override
    @Nullable
    @NotEmpty
    public String getType() {
        return this.resolverType;
    }

    public void setType(@Nullable @NotEmpty String type) {
        this.resolverType = StringSupport.trimOrNull((String)type);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<MetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nonnull List<? extends MetadataResolver> newResolvers) throws ResolverException {
        this.checkSetterPreconditions();
        if (newResolvers == null || newResolvers.isEmpty()) {
            this.resolvers = CollectionSupport.emptyList();
            return;
        }
        this.resolvers = CollectionSupport.copyToList(newResolvers);
    }

    @Nonnull
    public DetectDuplicateEntityIDs getDetectDuplicateEntityIDs() {
        return this.detectDuplicateEntityIDs;
    }

    public void setDetectDuplicateEntityIDs(@Nullable DetectDuplicateEntityIDs strategy) {
        this.checkSetterPreconditions();
        this.detectDuplicateEntityIDs = strategy != null ? strategy : DetectDuplicateEntityIDs.Off;
    }

    @Override
    public boolean isRequireValidMetadata() {
        this.log.warn("Attempt to access unsupported requireValidMetadata property on ChainingMetadataResolver");
        return false;
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Setting requireValidMetadata is not supported on chaining resolver");
    }

    @Override
    @Nullable
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataResolver");
        return null;
    }

    @Override
    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataResolver");
    }

    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nullable Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = condition;
    }

    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<EntityDescriptor> iterator;
        this.checkComponentActive();
        Iterable<EntityDescriptor> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        DetectDuplicateEntityIDsCriterion dup;
        this.checkComponentActive();
        if (this.activationCondition != null && criteria != null) {
            ProfileRequestContextCriterion prc = (ProfileRequestContextCriterion)criteria.get(ProfileRequestContextCriterion.class);
            assert (this.activationCondition != null);
            if (!this.activationCondition.test(prc != null ? prc.getProfileRequestContext() : null)) {
                this.log.info("Metadata Resolver {}: Bypassed due to failed activation condition", (Object)this.getId());
                return CollectionSupport.emptyList();
            }
        }
        DetectDuplicateEntityIDs detectDuplicates = this.getDetectDuplicateEntityIDs();
        DetectDuplicateEntityIDsCriterion detectDuplicateEntityIDsCriterion = dup = criteria != null ? (DetectDuplicateEntityIDsCriterion)criteria.get(DetectDuplicateEntityIDsCriterion.class) : null;
        if (dup != null) {
            detectDuplicates = dup.getValue();
        }
        this.log.trace("Effective DetectDuplicateEntityIDs value is: {}", (Object)detectDuplicates);
        Iterable result = null;
        Set<String> resultEntityIDs = null;
        for (MetadataResolver resolver : this.resolvers) {
            try {
                if (result != null) {
                    assert (resolver != null);
                    this.detectDuplicateEntityIDs(resolver, criteria, resultEntityIDs, detectDuplicates);
                    continue;
                }
                Iterable descriptors = resolver.resolve(criteria);
                if (descriptors == null || !descriptors.iterator().hasNext()) continue;
                if (detectDuplicates == DetectDuplicateEntityIDs.Off) {
                    this.log.trace("Resolved EntityDescriptor(s) from '{}', duplicate detection disabled, returning", (Object)resolver.getId());
                    return descriptors;
                }
                this.log.trace("Resolved EntityDescriptor(s) from '{}', duplicate detection enabled, continuing", (Object)resolver.getId());
                result = descriptors;
                resultEntityIDs = this.collectEntityIDs(result);
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving metadata from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        if (result != null) {
            return result;
        }
        return CollectionSupport.emptyList();
    }

    private void detectDuplicateEntityIDs(@Nonnull MetadataResolver resolver, @Nullable CriteriaSet criteria, @Nullable Set<String> resultEntityIDs, @Nonnull DetectDuplicateEntityIDs detectDuplicates) {
        if (resultEntityIDs == null || resultEntityIDs.isEmpty()) {
            return;
        }
        switch (detectDuplicates) {
            case Off: {
                return;
            }
            case Batch: {
                if (BatchMetadataResolver.class.isInstance(resolver)) break;
                return;
            }
            case Dynamic: {
                if (DynamicMetadataResolver.class.isInstance(resolver)) break;
                return;
            }
            case All: {
                break;
            }
            default: {
                this.log.warn("Saw unknown DetectDuplicateEntityIDs value, can not process: {}", (Object)detectDuplicates);
                return;
            }
        }
        this.log.trace("Performing duplicate entityID detection on resolver '{} of type {}", (Object)resolver.getId(), (Object)resolver.getClass().getName());
        try {
            Iterable descriptors = resolver.resolve(criteria);
            if (descriptors != null && descriptors.iterator().hasNext()) {
                Set<String> descriptorsEnitityIDs = this.collectEntityIDs(descriptors);
                Set duplicates = resultEntityIDs.stream().filter(descriptorsEnitityIDs::contains).collect(Collectors.toSet());
                if (!duplicates.isEmpty()) {
                    this.log.warn("MetadataResolver '{}' contained duplicate entityIDs relative to the returned results: {}", (Object)resolver.getId(), duplicates);
                }
            }
        }
        catch (ResolverException e) {
            this.log.warn("During duplicate detection, error retrieving metadata from resolver '{}' of type {}", new Object[]{resolver.getId(), resolver.getClass().getName(), e});
        }
    }

    private Set<String> collectEntityIDs(@Nonnull Iterable<EntityDescriptor> descriptors) {
        return StreamSupport.stream(descriptors.spliterator(), false).map(EntityDescriptor::getEntityID).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void clear() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear();
        }
    }

    @Override
    public void clear(@Nonnull String entityID) throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear(entityID);
        }
    }

    @Override
    public void refresh() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            ((RefreshableMetadataResolver)resolver).refresh();
        }
    }

    @Override
    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableMetadataResolver)resolver).getLastUpdate();
            if (lastUpdate == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableMetadataResolver)resolver).getLastRefresh();
            if (lastRefresh == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastSuccessfulRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastSuccessRefresh = ((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh();
            if (lastSuccessRefresh == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastSuccessRefresh)) continue;
            ret = lastSuccessRefresh;
        }
        return ret;
    }

    @Override
    @Nullable
    public Boolean wasLastRefreshSuccess() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver downcast;
            Boolean flag;
            if (!(resolver instanceof RefreshableMetadataResolver) || (flag = (downcast = (RefreshableMetadataResolver)resolver).wasLastRefreshSuccess()) == null || flag.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Throwable getLastFailureCause() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver).getLastFailureCause() == null) continue;
            return refreshable.getLastFailureCause();
        }
        return null;
    }
}

