/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import jakarta.activation.DataSource;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Dispatch;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.http.HTTPBinding;
import jakarta.xml.ws.http.HTTPException;
import jakarta.xml.ws.soap.SOAPBinding;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DispatchImpl<T>
implements Dispatch<T>,
BindingProvider,
Closeable {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private static final String DISPATCH_NS = "http://cxf.apache.org/jaxws/dispatch";
    private static final String INVOKE_NAME = "Invoke";
    private static final String INVOKE_ONEWAY_NAME = "InvokeOneWay";
    private static final QName INVOKE_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "Invoke");
    private static final QName INVOKE_ONEWAY_QNAME = new QName("http://cxf.apache.org/jaxws/dispatch", "InvokeOneWay");
    private final Binding binding;
    private final EndpointReferenceBuilder builder;
    private final Client client;
    private final Class<T> cl;
    private final JAXBContext context;
    private Message error;
    private Service.Mode mode;

    DispatchImpl(Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz) {
        this.binding = ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding();
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)client.getEndpoint());
        this.client = client;
        this.mode = m;
        this.context = ctx;
        this.cl = clazz;
        this.setupEndpointAddressContext(client.getEndpoint());
        this.addInvokeOperation(false);
        this.addInvokeOperation(true);
        if (m == Service.Mode.MESSAGE && this.binding instanceof SOAPBinding) {
            if (DataSource.class.isAssignableFrom(clazz)) {
                this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"DataSource", m, "SOAP/HTTP"});
            } else if (m == Service.Mode.MESSAGE) {
                SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
                client.getOutInterceptors().add(saajOut);
                client.getOutInterceptors().add(new MessageModeOutInterceptor(saajOut, client.getEndpoint().getBinding().getBindingInfo().getName()));
                client.getInInterceptors().add(new SAAJInInterceptor());
                client.getInInterceptors().add(new MessageModeInInterceptor(clazz, client.getEndpoint().getBinding().getBindingInfo().getName()));
            }
        } else if (m == Service.Mode.PAYLOAD && this.binding instanceof SOAPBinding && SOAPMessage.class.isAssignableFrom(clazz)) {
            this.error = new Message("DISPATCH_OBJECT_NOT_SUPPORTED", LOG, new Object[]{"SOAPMessage", m, "SOAP/HTTP"});
        }
    }

    DispatchImpl(Client cl, Service.Mode m, Class<T> clazz) {
        this(cl, m, null, clazz);
    }

    private void addInvokeOperation(boolean oneWay) {
        String name = oneWay ? INVOKE_ONEWAY_NAME : INVOKE_NAME;
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo opInfo = info.getInterface().addOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        MessageInfo mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Request"), MessageInfo.Type.INPUT);
        opInfo.setInput(name + "Request", mInfo);
        MessagePartInfo mpi = mInfo.addMessagePart("parameters");
        if (this.context == null) {
            mpi.setTypeClass(this.cl);
        }
        mpi.setElement(true);
        if (!oneWay) {
            mInfo = opInfo.createMessage(new QName(DISPATCH_NS, name + "Response"), MessageInfo.Type.OUTPUT);
            opInfo.setOutput(name + "Response", mInfo);
            mpi = mInfo.addMessagePart("parameters");
            mpi.setElement(true);
            if (this.context == null) {
                mpi.setTypeClass(this.cl);
            }
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    private void addInvokeOperation(QName operationName, boolean oneWay) {
        ServiceInfo info = this.client.getEndpoint().getEndpointInfo().getService();
        OperationInfo invokeOpInfo = info.getInterface().getOperation(oneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME);
        OperationInfo opInfo = info.getInterface().addOperation(operationName);
        opInfo.setInput(invokeOpInfo.getInputName(), invokeOpInfo.getInput());
        if (!oneWay) {
            opInfo.setOutput(invokeOpInfo.getOutputName(), invokeOpInfo.getOutput());
        }
        for (BindingInfo bind : this.client.getEndpoint().getEndpointInfo().getService().getBindings()) {
            BindingOperationInfo bo = new BindingOperationInfo(bind, opInfo);
            bind.addOperation(bo);
        }
    }

    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.client.getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <X extends EndpointReference> X getEndpointReference(Class<X> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            WrappedMessageContext requestContext = new WrappedMessageContext(this.client.getRequestContext(), null, MessageContext.Scope.APPLICATION);
            requestContext.put("jakarta.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    private void checkError() {
        if (this.error != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = null;
                try {
                    soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), new Exception(this.error.toString()));
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                if (soapFault != null) {
                    throw new SOAPFaultException(soapFault);
                }
            } else if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)new Exception(this.error.toString()));
                throw exception;
            }
            throw new WebServiceException(this.error.toString());
        }
    }

    private RuntimeException mapException(Exception ex) {
        if (ex instanceof Fault && ex.getCause() instanceof IOException) {
            throw new WebServiceException(ex.getMessage(), ex.getCause());
        }
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            return exception;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFault soapFault = null;
            try {
                soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            if (soapFault == null) {
                return new WebServiceException((Throwable)ex);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            exception.initCause((Throwable)ex);
            return exception;
        }
        return new WebServiceException((Throwable)ex);
    }

    public T invoke(T obj, boolean isOneWay) {
        this.checkError();
        try {
            boolean hasOpName;
            if (obj instanceof SOAPMessage) {
                SOAPMessage msg = (SOAPMessage)obj;
                if (msg.countAttachments() > 0) {
                    this.client.getRequestContext().put("write.attachments", Boolean.TRUE);
                }
            } else if (this.context != null) {
                Boolean unwrapProperty = obj instanceof JAXBElement ? Boolean.FALSE : Boolean.TRUE;
                this.getRequestContext().put("unwrap.jaxb.element", unwrapProperty);
            }
            QName opName = (QName)this.getRequestContext().get("jakarta.xml.ws.wsdl.operation");
            if (opName == null) {
                hasOpName = false;
                opName = isOneWay ? INVOKE_ONEWAY_QNAME : INVOKE_QNAME;
            } else {
                hasOpName = true;
                BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                if (bop == null) {
                    this.addInvokeOperation(opName, isOneWay);
                }
            }
            Holder holder = new Holder(obj);
            opName = this.calculateOpName(holder, opName, hasOpName);
            Object[] ret = this.client.invokeWrapped(opName, new Object[]{holder.value});
            if (isOneWay || ret == null || ret.length == 0) {
                return null;
            }
            return (T)ret[0];
        }
        catch (ClientImpl.IllegalEmptyResponseException ie) {
            return null;
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private QName calculateOpName(Holder<T> holder, QName opName, boolean hasOpName) throws XMLStreamException {
        boolean findDispatchOp = Boolean.TRUE.equals(this.getRequestContext().get("find.dispatch.operation"));
        if (!findDispatchOp) {
            List<Feature> allFeatures;
            List<Feature> endpointFeatures = ((JaxWsClientEndpointImpl)this.client.getEndpoint()).getFeatures();
            if (this.client.getBus().getFeatures() != null) {
                allFeatures = new ArrayList<Feature>(endpointFeatures.size() + this.client.getBus().getFeatures().size());
                allFeatures.addAll(endpointFeatures);
                allFeatures.addAll(this.client.getBus().getFeatures());
            } else {
                allFeatures = endpointFeatures;
            }
            for (Feature feature : allFeatures) {
                if (!(feature instanceof WSAddressingFeature)) continue;
                findDispatchOp = true;
            }
        }
        StaxSource createdSource = null;
        Map<String, QName> payloadOPMap = this.createPayloadEleOpNameMap(this.client.getEndpoint().getBinding().getBindingInfo(), hasOpName);
        if (findDispatchOp && !payloadOPMap.isEmpty()) {
            QName payloadElementName = null;
            if (holder.value instanceof Source) {
                XMLStreamReader reader = null;
                try {
                    reader = StaxUtils.createXMLStreamReader((Source)((Source)holder.value));
                    Document document = StaxUtils.read((XMLStreamReader)reader);
                    createdSource = new StaxSource(StaxUtils.createXMLStreamReader((Document)document));
                    payloadElementName = this.getPayloadElementName(document.getDocumentElement());
                }
                catch (Exception document) {
                    StaxUtils.close((XMLStreamReader)reader);
                    catch (Throwable throwable) {
                        StaxUtils.close(reader);
                        throw throwable;
                    }
                }
                StaxUtils.close((XMLStreamReader)reader);
            }
            if (holder.value instanceof SOAPMessage) {
                payloadElementName = this.getPayloadElementName((SOAPMessage)holder.value);
            }
            if (this.context != null) {
                payloadElementName = this.getPayloadElementName(holder.value);
            }
            if (payloadElementName != null) {
                BindingOperationInfo dbop;
                QName expectedElementName;
                if (hasOpName && ((expectedElementName = payloadOPMap.get(opName.toString())) == null || !expectedElementName.toString().equals(payloadElementName.toString()))) {
                    hasOpName = false;
                    payloadOPMap = this.createPayloadEleOpNameMap(this.client.getEndpoint().getBinding().getBindingInfo(), hasOpName);
                }
                QName dispatchedOpName = null;
                if (!hasOpName) {
                    dispatchedOpName = payloadOPMap.get(payloadElementName.toString());
                }
                if (null != dispatchedOpName && (dbop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(dispatchedOpName)) != null) {
                    opName = dispatchedOpName;
                }
            }
        }
        if (createdSource != null) {
            holder.value = createdSource;
        }
        return opName;
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        this.checkError();
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        JaxwsClientCallback callback = new JaxwsClientCallback<T>(asyncHandler, this){

            @Override
            protected Throwable mapThrowable(Throwable t) {
                if (t instanceof IOException) {
                    return t;
                }
                if (t instanceof Exception) {
                    t = DispatchImpl.this.mapException((Exception)t);
                }
                return t;
            }
        };
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        try {
            boolean hasOpName;
            QName opName = (QName)this.getRequestContext().get("jakarta.xml.ws.wsdl.operation");
            if (opName == null) {
                hasOpName = false;
                opName = INVOKE_QNAME;
            } else {
                hasOpName = true;
                BindingOperationInfo bop = this.client.getEndpoint().getBinding().getBindingInfo().getOperation(opName);
                if (bop == null) {
                    this.addInvokeOperation(opName, false);
                }
            }
            Holder holder = new Holder(obj);
            opName = this.calculateOpName(holder, opName, hasOpName);
            this.client.invokeWrapped((ClientCallback)callback, opName, new Object[]{holder.value});
            return ret;
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public Response<T> invokeAsync(T obj) {
        return (Response)this.invokeAsync(obj, null);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public Client getClient() {
        return this.client;
    }

    private QName getPayloadElementName(Element ele) {
        XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader((Element)ele);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xmlreader);
        try {
            if (this.mode == Service.Mode.PAYLOAD) {
                StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                return reader.getName();
            }
            if (this.mode == Service.Mode.MESSAGE) {
                StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                StaxUtils.toNextTag((DepthXMLStreamReader)reader, (QName)new QName(ele.getNamespaceURI(), "Body"));
                reader.nextTag();
                return reader.getName();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return null;
    }

    private QName getPayloadElementName(SOAPMessage soapMessage) {
        try {
            Element element = DOMUtils.getFirstElement((Node)SAAJUtils.getBody((SOAPMessage)soapMessage));
            if (element != null) {
                return DOMUtils.getElementQName((Element)element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private QName getPayloadElementName(Object object) {
        block13: {
            DepthXMLStreamReader reader;
            XMLStreamWriter resultWriter;
            block12: {
                JAXBDataBinding dataBinding = new JAXBDataBinding();
                dataBinding.setContext(this.context);
                DataWriter dbwriter = dataBinding.createWriter(XMLStreamWriter.class);
                StringWriter stringWriter = new StringWriter();
                resultWriter = StaxUtils.createXMLStreamWriter((Writer)stringWriter);
                reader = null;
                dbwriter.write(object, (Object)resultWriter);
                resultWriter.flush();
                if (StringUtils.isEmpty((String)stringWriter.toString())) break block12;
                ByteArrayInputStream binput = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes());
                XMLStreamReader xmlreader = StaxUtils.createXMLStreamReader((InputStream)binput);
                reader = new DepthXMLStreamReader(xmlreader);
                StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader);
                QName qName = reader.getName();
                try {
                    StaxUtils.close((XMLStreamReader)reader);
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
                StaxUtils.close((XMLStreamWriter)resultWriter);
                return qName;
            }
            try {
                StaxUtils.close(reader);
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            StaxUtils.close((XMLStreamWriter)resultWriter);
            break block13;
            catch (XMLStreamException xMLStreamException) {
                try {
                    StaxUtils.close(reader);
                }
                catch (XMLStreamException xMLStreamException2) {
                    // empty catch block
                }
                StaxUtils.close((XMLStreamWriter)resultWriter);
                catch (Throwable throwable) {
                    try {
                        StaxUtils.close(reader);
                    }
                    catch (XMLStreamException xMLStreamException3) {
                        // empty catch block
                    }
                    StaxUtils.close((XMLStreamWriter)resultWriter);
                    throw throwable;
                }
            }
        }
        return null;
    }

    private Map<String, QName> createPayloadEleOpNameMap(BindingInfo bindingInfo, boolean reverseMapping) {
        String tempStyle;
        HashMap<String, QName> payloadElementMap = new HashMap<String, QName>();
        String bindingStyle = "document";
        if (bindingInfo instanceof SoapBindingInfo && (tempStyle = ((SoapBindingInfo)bindingInfo).getStyle()) != null) {
            bindingStyle = tempStyle;
        }
        for (BindingOperationInfo bop : bindingInfo.getOperations()) {
            String operationStyle;
            SoapOperationInfo soi = (SoapOperationInfo)bop.getExtensor(SoapOperationInfo.class);
            if (soi == null) continue;
            String string = operationStyle = soi.getStyle() != null ? soi.getStyle() : bindingStyle;
            if ("document".equals(operationStyle)) {
                if (bop.getOperationInfo().getInput() == null || bop.getOperationInfo().getInput().getMessagePartsNumber() <= 0) continue;
                QName qn = bop.getOperationInfo().getInput().getMessagePartByIndex(0).getElementQName();
                QName op = bop.getOperationInfo().getName();
                if (reverseMapping) {
                    payloadElementMap.put(op.toString(), qn);
                    continue;
                }
                payloadElementMap.put(qn.toString(), op);
                continue;
            }
            if (!"rpc".equals(operationStyle)) continue;
            QName op = bop.getOperationInfo().getName();
            payloadElementMap.put(op.toString(), op);
        }
        return payloadElementMap;
    }

    @Override
    public void close() throws IOException {
        this.client.destroy();
    }
}

